<?php
namespace wcf\data\wow\event;
use wcf\data\DatabaseObject;
/**
 * Represents a WoW Calender Attendend.
 * 
 * @author	Veneanar Falkenbann
 * @copyright	2015 Sylvanas Garde
 * @package	com.sylvanasgarde.tools
 * @subpackage	system.BNET
 * @category	Guild Tools
 * 
 * @property int    $attendID PRIMARY KEY
 * @property int    $eventID id of an event
 * @property int    $charID id of the wow char
 * @property int    $state attender status. 1: signed, 2: accepted, 3: stand by, 4: tentative, 5: declined, 6: invited
 * @property int    $attended attended?
 * @property int    $lastUpdate timestamp
 * 
 * 
 */
class WoWEventAttend extends DatabaseObject {
    /**
     * @see wcf\data\DatabaseObject::$databaseTableName
     */
    protected static $databaseTableName = 'guildtool_eventattend';
    /**
     * @see wcf\data\DatabaseObject::$databaseTableIndexName
     */
    protected static $databaseTableIndexName = 'attendID';

}