<?php
namespace wcf\system\wow;
use wcf\util\HTTPTools;
use wcf\system\exception\SystemException;
use wcf\system\WCF;
use wcf\util\StringUtil;

/**
 * The BnetAPI class handles all needed API bnet operations.
 * 
 * @author	    Veneanar
 * @copyright	2015 Sylvanas Garde
 * @package	    com.sylvanasgarde.guildtool
 * @category    Dataparser
 */
class BNETAPI extends HTTPTools{

    /**
     * internal function for connected Realmlist
     * 
     * @param	string		$character
     * @return	array		
     */
    private static function getRealmList() {
        return array_map('trim', explode(',', GUILDTOOL_GUILD_CONNECTEDREALM));
    }

    /**
     * get List of all Guildmembers
     * return array: (status: boolean, array: memberlist)
     * see GUILD PROFILE API https://dev.battle.net/io-docs
     * GET MEMBERS /WOW/GUILD/:REALM/:GUILDNAME
     * 
     * @return	array		
     */
    public static function getGuildRoster() {
        $newarmory = array();
        $armoryresult = self::open('https://'.GUILDTOOL_BNET_API_HOST .'/wow/guild/'.rawurlencode(GUILDTOOL_GUILD_HOMEREALM).'/'.rawurlencode(GUILDTOOL_GUILD_NAME).'?locale='. GUILDTOOL_BNET_API_LANGUAGE. '&fields=members&apikey='. GUILDTOOL_BNET_API_KEY);
        if ($armoryresult['status']==200) {
            $t_res = json_decode($armoryresult['content'], true);
            foreach($t_res['members'] as $t_member) {
                $t_member['character']['rank'] = empty($t_member['rank']) ? 10 : $t_member['rank'];
                if ($t_member['character']['name'] == GUILDTOOL_GUILD_GUILDMASTER && $t_member['character']['realm'] == GUILDTOOL_GUILD_HOMEREALM)  $t_member['character']['rank']=0;
                $newarmory['members'][] = $t_member;
            }
            return array('status'=>true, 'data'=> $newarmory);
        }
        return array('status'=>false, 'data'=> $newarmory);
    }

    /**
     * get List of all Guildmembers
     * return array: (status: boolean, array: feedlist)
     * see GUILD NEWS API https://dev.battle.net/io-docs
     * GET MEMBERS /WOW/GUILD/:REALM/:GUILDNAME
     * 
     * @param   string Filter for the Feeds: itemLoot, itemCraft, guildAchievement, playerAchievement
     * @return	array		
     */
   public static function getGuildFeed($filter = null) {
       $newsarray = array();
       $armoryresult = self::open('https://'.GUILDTOOL_BNET_API_HOST .'/wow/guild/'.rawurlencode(GUILDTOOL_GUILD_HOMEREALM).'/'.rawurlencode(GUILDTOOL_GUILD_NAME).'?locale='. GUILDTOOL_BNET_API_LANGUAGE. '&fields=news&apikey='. GUILDTOOL_BNET_API_KEY);
       if ($armoryresult['status']==200) {
           $t_res = json_decode($armoryresult['content'], true);
           if (empty($filter)) {
               $newsarray = $t_res['news'];    
           }
           else {
               foreach($t_res['news'] as $t_news) {
                    if ($t_news['type']==$filter) {
                        $newsarray[] = $t_news;
                    }
               }           
           }
           return array('status'=>true, 'data'=> $newsarray);
       }
       return array('status'=>false, 'data'=> $newsarray);
   } 
   /**
     * returns the Homerealm of a charcter
     * return array: (status: boolean, realmname: string)
     * 
     * @param	string		$character
     * @return	array		
     */
    public static function getHomeRealm($character, $override = false) {
        $realmlist = static::getRealmList();
        foreach($realmlist as $realm) {
            $armoryresult = self::open('https://'. GUILDTOOL_BNET_API_HOST .'/wow/character/'.rawurlencode($realm).'/'.rawurlencode($character).'?apikey='. GUILDTOOL_BNET_API_KEY);
            if ($armoryresult['status'] == 200) return array('status'=>true, 'data'=>$realm);
        }
        return $override ? array('status'=>true, 'data'=>GUILDTOOL_GUILD_HOMEREALM) : array('status'=>false, 'data'=>array());
    }
    /**
     * returns the detail of an item
     * return array: (status: boolean, realmname: string)
     * 
     * @param	int		$itemID ID of an item
     * @return	array		
     */
    public static function getItemInfo($itemID) {
        $armoryresult = self::open('https://'. GUILDTOOL_BNET_API_HOST .'/wow/item/'.rawurlencode($itemID).'?locale='. GUILDTOOL_BNET_API_LANGUAGE. '&apikey='. GUILDTOOL_BNET_API_KEY);
        return ($armoryresult['status'] == 200) ? array('status'=>true, 'data'=>$armoryresult) : array('status'=>false, 'data'=>array());
    }


    /**
     * returns the staus of the connected realms 
     * return array: (name: string, status: feedlist)
     * 
     * @return	array		
     */
    public static function getRealmState() {
        $realmlist = static::getRealmList();
        $return = array();
        $failreturn = array();
        $webrealmlist = '';
        foreach($realmlist as $realm) {
            $failreturn[] = array(
                'name' => $realm,
                'status' => false
            );
            $realm = str_replace(' ', '-', $realm);
            $webrealmlist .=  rawurlencode($realm) . ','; 
        }
        $armoryresult = self::open('https://'. GUILDTOOL_BNET_API_HOST.'/wow/realm/status?realms='.$webrealmlist.'&locale='. GUILDTOOL_BNET_API_LANGUAGE . '&apikey='. GUILDTOOL_BNET_API_KEY);
        if ($armoryresult['status'] == 200) {
            $armory = json_decode($armoryresult['content'], true);
            foreach($armory['realms'] as $realmstate) {
                $return[] = array(
                    'name' => $realmstate['name'],
                    'status' => $realmstate['status']
               );
            }
            return $return;
        }
        else {
            return $failreturn;
        }
    }
    /**
     * get details of a Char
     * 
     * return array: (successfull: boolean, array: Chardetails)
     * see GUILD PROFILE API https://dev.battle.net/io-docs
     * GET CHARACTER PROFILE /WOW/CHARACTER/:REALM/:CHARACTERNAME
     * for options you can use every method from CHARACTER PROFILE 
     * 
     * @param	string		$character
     * @param	string		$realm
     * @param	array		$options
     * @return	array		
     */
    public static function getCharacterDetails($character, $realm, $options = array()) {
        $querystring = (empty($options)) ? '' : '&fields=';
        foreach($options as $option) {
            $querystring .= $option .',';
        }
        $armoryresult = self::open('https://'.GUILDTOOL_BNET_API_HOST .'/wow/character/'.$realm.'/'.$character.'?locale='. GUILDTOOL_BNET_API_LANGUAGE .$querystring.'&apikey='. GUILDTOOL_BNET_API_KEY);
        return ($armoryresult['status']==200) ? array('status'=>true, 'data'=>json_decode($armoryresult['content'],true)) : array('status'=>false, 'data'=>'');
    }

}