<?php
namespace wcf\system\cache\builder;
use \wcf\data\wow\event\WoWEventCalendar;

/**
 * Provides realm status
 * 
 * @author	Veneanar Falkenbann
 * @copyright	2015 Sylvanas Garde
 * @package	com.sylvanasgarde.tools
 * @subpackage	system.BNET
 * @category	Guild Tools
 */

class WoWCalendarCacheBuilder extends AbstractCacheBuilder {
	/**
     * @see		\wcf\system\cache\builder\AbstractCacheBuilder::$maxLifetime
     */
	protected $maxLifetime = 120;
	
	/**
     * @see		\wcf\system\cache\builder\AbstractCacheBuilder::rebuild()
     */
	protected function rebuild(array $parameters) {
        $WoWCalendar = new WoWEventCalendar(@$parameters['filter'], @$parameters['start'], @$parameters['end']);
		return $WoWCalendar->getCalendar();
	}
}
