DROP TABLE IF EXISTS wcf1_guildtool_eventattend;
CREATE TABLE wcf1_guildtool_eventattend (
  attendID int(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
  eventID int(11) NOT NULL,
  charID int(11) NOT NULL,
  state tinyint(4) NOT NULL,
  attended tinyint(4) NOT NULL DEFAULT '0',
  lastUpdate timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  KEY (eventID)
);

DROP TABLE IF EXISTS wcf1_guildtool_events;
CREATE TABLE wcf1_guildtool_events (
  eventID int(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
  name varchar(50)  NOT NULL,
  groupID int(11) NOT NULL DEFAULT '0',
  description varchar(1000)  NOT NULL,
  time int(11) NOT NULL,
  icon varchar(100)  NOT NULL,
  comment text ,
  link text ,
  state tinyint(1) NOT NULL DEFAULT '1',
  promo tinyint(1) NOT NULL DEFAULT '0'
);

DROP TABLE IF EXISTS wcf1_guildtool_guildgroups;
CREATE TABLE wcf1_guildtool_guildgroups (
  groupID int(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
  wcfGroupID int(11) NOT NULL DEFAULT '0',
  name varchar(100)  NOT NULL,
  leader varchar(100)  NOT NULL, 
  groupURL varchar(255)  NOT NULL,
  searchCalenadarQuerry varchar(20)  NOT NULL,
  renderEventsPup tinyint(1) NOT NULL DEFAULT '1',
  showRoasterPup tinyint(1) NOT NULL DEFAULT '1',
  renderEventsForum text,
  showRoasterForum text,
  groupShortDesc text,
  groupLongDesc text,
  groupPicture text,
  groupLogo varchar(255)  NOT NULL, 
  publish tinyint(1) NOT NULL DEFAULT '1',
  publishFeed tinyint(1) NOT NULL DEFAULT '0',
  countAttend tinyint(1) NOT NULL DEFAULT '0',
  pointarray text,  
  KEY (wcfGroupID)
);

DROP TABLE IF EXISTS wcf1_guildtool_loottracker;
CREATE TABLE wcf1_guildtool_loottracker (
  lootID int(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
  charID int(11) NOT NULL,
  itemID int(11) NOT NULL,
  groupID int(11) NOT NULL,
  loottype varchar(50),
  transactionID int(11) NOT NULL,
  time int(11) NOT NULL,
  KEY(charID), 
  KEY(groupID)   
);

DROP TABLE IF EXISTS wcf1_guildtool_playerdata;
CREATE TABLE wcf1_guildtool_playerdata (
  charID int(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
  charname varchar(20) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  realmname varchar(25)  NOT NULL,
  class int(11) DEFAULT NULL,
  race int(11) DEFAULT NULL,
  gender int(11) NOT NULL,
  level int(11) DEFAULT NULL,
  avatar text ,
  userID int(11) NOT NULL,
  inGuild tinyint(1) NOT NULL,
  primaryRole tinyint(4) DEFAULT NULL,
  secondaryRole tinyint(4) DEFAULT NULL,
  isMain tinyint(4) DEFAULT NULL,
  guildGroup text ,
  rank tinyint(4) NOT NULL DEFAULT '15',
  achievementPoints int(11) NOT NULL DEFAULT '0',
  state tinyint(1) NOT NULL DEFAULT '1'
);

DROP TABLE IF EXISTS wcf1_guildtool_token;
CREATE TABLE wcf1_guildtool_token (
  price  int(11)  NOT NULL,
  low24  int(11)  NOT NULL,
  high24 int(11)  NOT NULL,
  time   int(11) NOT NULL PRIMARY KEY
);


DROP TABLE IF EXISTS wcf1_guildtool_feed_acm;
CREATE TABLE wcf1_guildtool_feed_acm (
  feedID int(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
  acmID int(11) NOT NULL,
  charID int(11) NOT NULL,
  time int(11) NOT NULL,
  KEY(acmID), 
  KEY(charID)
);

DROP TABLE IF EXISTS wcf1_guildtool_wowdata_acm;
CREATE TABLE wcf1_guildtool_wowdata_acm (
  acmID int(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
  title text  NOT NULL,
  description text  NOT NULL,
  icon varchar(300)  NOT NULL,
  points tinyint(4) NOT NULL
);

DROP TABLE IF EXISTS wcf1_guildtool_points;
CREATE TABLE wcf1_guildtool_points (
  transID int(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
  charID int(11) NOT NULL,
  eventID int(11) NOT NULL DEFAULT '0',
  lootID int(11) NOT NULL DEFAULT '0',
  amount int(11) NOT NULL,
  issuerID int(11) NOT NULL DEFAULT '0',
  comment text NOT NULL,
  time int(11) NOT NULL
); 

DROP TABLE IF EXISTS wcf1_guildtool_wowdata_item;
CREATE TABLE wcf1_guildtool_wowdata_item (
  itemID int(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
  name varchar(200) NOT NULL,
  description text NOT NULL,
  icon varchar(250) NOT NULL
);