<?php
namespace wcf\form;
use wcf\data\user\User;
use wcf\system\WCF;
use wcf\util\HeaderUtil;
use wcf\system\request\LinkHandler;
use wcf\util\DateUtil;
use wbb\data\thread\ThreadAction;
use wbb\system\label\object\ThreadLabelObjectHandler;
use wcf\system\wow\WCLAPI;
use wbb\data\post\PostAction;
use wbb\data\thread\ThreadList;
use wbb\data\post\Post;

/**
 * Shows the Group details
 * 
 * 
 * @author	Veneanar Falkenbann
 * @copyright	2015 Sylvanas Garde
 * @package	com.sylvanasgarde.tools
 * @subpackage	system.BNET
 * @category	Guild Tools

 */

class GuildOfficierReportForm extends AbstractForm {
	/**
	 * @see	\wcf\page\AbstractPage::$activeMenuItem
	 */
    public $activeMenuItem = 'wcf.page.GuildTool.GuildOfficierReport';

	public $templateName = 'guildOfficierReport';
	
	// parameters
	public $threadID = '';

    public $internalReport = '';

    public $publicReport = '';

    public $nextAgendaTitle = '';

    public $nextAgendaContent = '';

    public $reportTitle = '';

    public $workreport = '';

	
	/**
	 * @see Form::readFormParameters()
	 */
	public function readFormParameters() {
		parent::readFormParameters();
        $this->threadID = @$_REQUEST['threadID'] ?: 0;
        $this->reportTitle = @$_REQUEST['reportTitle'] ?: "";	
        $this->workreport = @$_REQUEST['internalReport'] ?: "";	
        $this->nextAgendaTitle = @$_REQUEST['nextAgendaTitle'] ?: "";	
        $this->nextAgendaContent = @$_REQUEST['nextAgendaContent'] ?: "";	

	}
	
	/**
	 * @see	\wcf\form\IForm::validate()
	 */
	public function validate() {
		parent::validate();
        }
        
        
	
	/**
	 * @see Form::save()
	 */
	public function save() {
		parent::save();
        $workString = explode("\n",$this->workreport);
        foreach ($workString as $line ) {
            $pos = strpos($line, '//');
            if ($pos === false || $pos > 2) {
                $this->internalReport .= $line;
                $this->publicReport .= $line;
            } else {
                $this->internalReport .= str_replace('//', '', $line);
            }           
        }


        $userid = intval(@WCF::getUser()->userID ?: 1);
        $systemAuthour = new User(1);
        $protocollAuthor = new User(intval($userid));
        // board 23 test 3
        $data = array(
             'boardID' => 23,
             'languageID' => NULL,
             'topic' => $this->nextAgendaTitle,
             'time' => TIME_NOW,
             'userID' => 1,
             'username' => $systemAuthour->username,
             'hasLabels' => 0
         );
        $threadData = array(
            'data' => $data,
            'attachmentHandler' => null,
            'postData' => array(
               'message' => $this->nextAgendaContent,
               'enableBBCodes' => 1,
               'enableHtml' => 0,
               'enableSmilies' => 1,
               'showSignature' => 1
            ),
            'tags' => array(),
            'subscribeThread' => 0
        );
        $objectAction = new ThreadAction(array(), 'create', $threadData);
        $objectAction->executeAction();
        // thread 5286 test: 2
        $data = array(
            'threadID' =>5286,
            'subject' => $this->reportTitle,
            'message' => $this->publicReport,
            'time' => TIME_NOW,
            'userID' => 1,
            'username' => $systemAuthour->username,
            'enableBBCodes' => 1,
            'enableHtml' => 0,
            'enableSmilies' => 0,	
            'showSignature' => 0,
         );
  
        $objectAction = new PostAction(array(), 'create', array('data' =>$data));
        $objectAction->executeAction();
        $data = array(
            'threadID' =>$this->threadID,
            'subject' => $this->reportTitle,
            'message' => $this->internalReport,
            'time' => TIME_NOW,
            'userID' => $userid,
            'username' => $protocollAuthor->username,
            'enableBBCodes' => 1,
            'enableHtml' => 0,
            'enableSmilies' => 0,	
            'showSignature' => 0,
         );
        var_dump($data);
        $objectAction = new PostAction(array(), 'create', array('data' =>$data));
        $objectAction->executeAction();

		$this->saved();
		HeaderUtil::redirect('https://sylvanasgarde.com/forum/index.php/Board/23-Sitzungsprotokolle/');
		exit;
	}
        
	/**
	 * @see Page::assignVariables()
	 */
	public function assignVariables() {
		parent::assignVariables();
        $threadList = new ThreadList();
        $threadList->getConditionBuilder()->add(' time < UNIX_TIMESTAMP(NOW()) AND time > UNIX_TIMESTAMP(DATE_SUB(NOW(), INTERVAL 24 DAY))');
        $threadList->getConditionBuilder()->add('boardID = 23');

        $threadList->sqlOrderBy = 'time DESC';

        $threadList->readObjects();
        // 11010 Tst: 3
        $agendaPost = new Post(11010);
        $agendaTemplate = $agendaPost->getMessage();
        // 11009 Test: 2
        $protocollPost = new Post(11009);
        $protocollTemplate = $protocollPost->getMessage();

        $nextMeetingDate = new \DateTime('now',new \DateTimeZone('UTC'));
        $nextMeetingDate->modify('Wednesday next week');
        $currentMeeting = new \DateTime('now',new \DateTimeZone('UTC'));
        // $threadList->getObjects(),
		WCF::getTPL()->assign(array(
			'threads' => $threadList->getObjects(),
            'reportTemplate' => $protocollTemplate,
            'agendaTemplate' => $agendaTemplate,
            'nextAgendaTitle' => 'Tagesordnung der Ratssitzung am ' . DateUtil::format($nextMeetingDate),
            'reportTitle' => 'Protokoll der Ratssitzung vom ' . DateUtil::format($currentMeeting)
		));
	}
}
?>