<?php
namespace wcf\data\wow\item;
use wcf\system\exception\SystemException;
use wcf\data\DatabaseObject;
use wcf\system\WCF;
/**
 * Represents a WoW Item.
 * 
 * @author	Veneanar Falkenbann
 * @copyright	2015 Sylvanas Garde
 * @package	com.sylvanasgarde.tools
 * @subpackage	system.BNET
 * @category	Guild Tools
 */
class WoWItem extends DatabaseObject {
    /**
     * @see wcf\data\DatabaseObject::$databaseTableName
     */
    protected static $databaseTableName = 'guildtool_wowdata_item';
    /**
     * @see wcf\data\DatabaseObject::$databaseTableIndexName
     */
    protected static $databaseTableIndexName = 'itemID';
    /**
     * creates a new Item if not exist
     * 
     * @param array $itemdata battle.net data
     * @return \wcf\data\wow\item\wowitem
     */
    public static function create($itemdata) {
        if (empty($acmdata['id'])) {
            throw new SystemException('Data Error');
        }
        $itemTest = new WoWItem($itemdata['id']);
        if (intval($itemTest->getObjectID()) > 0) {
            return $itemTest;    
        } 
        else {
            $acm = array(
            'itemID' => $itemdata['id'],
            'title' => $itemdata['name'],
            'description' => $itemdata['description'],
            'icon' => $itemdata['icon'],
            );
            return WoWItemEditor::create($acm);
        }
    }
}