<?php
namespace wcf\data\wow\event;

/**
 * Renders a calendar view.
 * 
 * @author	Veneanar Falkenbann
 * @copyright	2015 Sylvanas Garde
 * @package	com.sylvanasgarde.tools
 * @subpackage	data.wow
 * @category	Guild Tools
 *
 */
class WoWEventCalendar extends WoWEventList {
    /**
     * $startDateTime
     * startdate for the eventlist
     * @var	 \DateTime
     */
    protected $startDateTime = null;
    /**
     * $endDateTime
     * startdate for the eventlist
     * @var	\DateTime
     */
    protected $endDateTime = null;
    /**
     * $eventList
     * plain Eventlist
     * @var	array
     * @see \wcf\data\wow\event\WoWEventList
     */
    public $eventList = null;

    /**
     * create new calendar
     * 
     * @param $eventfilter string[] list of eventname to filter
     * @param $eventfilter string[] start=>relative start date, end=> realtive end date  
     * @see http://php.net/manual/de/datetime.formats.relative.php	
     */
    public function __construct($eventfilter = array(), $start = 'monday this week', $end = '+ 14 days') {
        parent::__construct();
        $start = isset($start) ? $start : 'monday this week';
        $end = isset($end) ? $end : '+ 14 days';
        $eventfilter = empty($eventfilter) ? array() : $eventfilter;
        $this->startDateTime = new \DateTime('now',new \DateTimeZone('UTC'));
        $this->startDateTime->modify($start);
        $this->endDateTime = new \DateTime($this->startDateTime->format('Y-m-d'),new \DateTimeZone('UTC'));
        $this->endDateTime->modify($end);
        foreach ($eventfilter as $eventname) {
            self::getConditionBuilder()->add('name LIKE ?', array($eventname));
        }
        $this->getConditionBuilder()->add('time > ?', array($this->startDateTime->getTimestamp()));
        $this->getConditionBuilder()->add('time < ?', array($this->endDateTime->getTimestamp()));
        $this->sqlLimit = 0;
        $this->sqlOrderBy = 'time ASC';
        $this->readObjects();
        $this->eventList = $this->getObjects();
    }
    /**
     * return a calendar array (days from startdate to enddate)
     * 
     * @return array ['date']: startdate ['events'] array of days, each day contain a list of events 
     * @see \wcf\system\wow\WoWEventList		
     */

    public function getCalendar() {
        $dateInterval = new \DateInterval('P1D');
        $datePeriod = new \DatePeriod($this->startDateTime, $dateInterval ,$this->endDateTime);
        $eventCalendar = array();
        foreach($datePeriod as $startdate){
            $enddate = new \DateTime($startdate->format('Y-m-d'),new \DateTimeZone('UTC'));
            $enddate->modify('+ 1 day');
            $events = array();
            foreach($this->eventList as $event) {
                $eventstart = new \DateTime('' ,new \DateTimeZone('UTC'));
                $eventstart->setTimestamp($event->time);
                if (($eventstart >= $startdate) && ($eventstart < $enddate)) {
                    $events[] = $event;
                }
            }
            $eventCalendar[] = array(
                'date' => $startdate,
                'events' => $events
                );  
        }
        return $eventCalendar;
    }
}    