<?php
namespace wcf\data\wow\event;
use wcf\data\wow\character\WoWCharacter;
use wcf\data\wow\character\WoWCharacterPoint;
use wcf\data\DatabaseObjectEditor;
use wcf\data\AbstractDatabaseObjectAction;
use\wcf\system\WCF;
use\wcf\util\StringUtil;
use wcf\system\exception\UserInputException;
use wcf\system\exception\PermissionDeniedException;
use wcf\system\wow\WCLAPI;
use wcf\system\cache\builder\WoWCalendarEventCacheBuilder;

/**
 * Provides functions to edit a WoW Event.
 * 
 * @author	Veneanar Falkenbann
 * @copyright	2015 Sylvanas Garde
 * @package	com.sylvanasgarde.tools
 * @subpackage	system.BNET
 * @category	Guild Tools
 * 
*/
class WoWEventAction extends AbstractDatabaseObjectAction {
	/**
     * @see	\wcf\data\AbstractDatabaseObjectAction::$className
     */
	public $className = 'wcf\data\wow\event\WoWEventEditor';
	
	/**
     * @see	\wcf\data\AbstractDatabaseObjectAction::$permissionsUpdate
     */
	protected $permissionsUpdate = array('mod.guildtool.canEditEvent');
    /**
     * @see	\wcf\data\AbstractDatabaseObjectAction::$permissionsDelete
     */
	protected $permissionsDelete = array('admin.guildtool.canDeleteEvent');	

	/**
     *  @see \wcf\data\AbstractDatabaseObjectAction::$allowGuestAccess
     */
	protected $allowGuestAccess = array('read', 'validateRead');

    /**
     * @see	\wcf\data\AbstractDatabaseObjectAction::$requireACP
     */
	protected $requireACP = array('create');

    protected $WoWChar = null;
    /**
     * Summary of $event
     * @var \wcf\system\cache\builder\WoWCalendarEventCacheBuilder
     */
    protected $event = null;

	/**
     * Validates permissions and parameters.
     */
	public function validateRead() {
		if (empty($this->objectIDs)) {
			throw new UserInputException("objectIDs");
		}
        if (empty($this->objects)) {
			$this->readObjects();
		}
		foreach ($this->objects as $event) {
			if ($event->state == 0) {
				throw new PermissionDeniedException();
			}
            //if (($event->renderEventsPup == 0) && (!in_array($event->groupID, WCF::getUser()->getGroupIDs()))) {
            //    throw new PermissionDeniedException();
            //}
		}
	}

    public function validateClose() {
		$this->validateRead();
		if (is_array($this->permissionsUpdate) && !empty($this->permissionsUpdate)) {
			WCF::getSession()->checkPermissions($this->permissionsUpdate);
		}
		else {
			throw new PermissionDeniedException();
		}
    }

    public function validateSynchronizeWCL() {
        $this->validateClose();
        if (empty($this->parameters['wclID']) ||  strlen($this->parameters['wclID']) < 6) {
            throw new UserInputException("WarcaftLog ID");
        }
    }

    public function validateGetEventWCLReportList() {
		$this->validateRead();
    }
    public function validateDelete() {
		$this->validateRead();
		if (is_array($this->permissionsDelete) && !empty($this->permissionsDelete)) {
			WCF::getSession()->checkPermissions($this->permissionsDelete);
		}
		else {
			throw new PermissionDeniedException();
		}
    }
    public function validateUpdate() {
		$this->validateClose();
    }

    public function validateToggleLockk() {
		$this->validateClose();
    }
    public function validateUpdateComment() {
		$this->validateClose();
    }
    public function validateUpdateLink() {
		$this->validateClose();
    }


    /**
     * read the EventDetails
     *  
     */
    public function read() {
        if (empty($this->objects)) {
			$this->readObjects();
		}
        $group = null;
        $WoWEvent = new WoWEvent($this->getObjectIDs()[0]);
        $attendees = array();
        if ($WoWEvent->eventGroup->groupID > 0) {
            $group = array(
                'check' => 'ja',
                'groupID' => $WoWEvent->eventGroup->groupID,
                'name' => $WoWEvent->eventGroup->name,
                'wcfGroupID' => $WoWEvent->eventGroup->wcfGroupID,
                'countAttend' => $WoWEvent->eventGroup->countAttend,
            );
        }
        else {
            $group = array(
                'groupID' => 0,
                'name' => '',
                'wcfGroupID' => 0,
                'countAttend' => 0,
            );
        }

        foreach ($WoWEvent->eventAttendees as $attender) {
            $attendees[] = array(
                'char' => new WoWCharacter($attender->charID),
                'state' => $attender->state,
                'attended' => $attender->attended,
                'attendID' => $attender->attendID
                );
        }
        //setlocale(LC_TIME, "de_DE.utf8", "German_Germany.1252", 'de_DE@euro', 'de_DE', 'deu_deu');
        $eventDateTime = new \DateTime('', new \DateTimeZone('UTC'));
        $eventDateTime->setTimestamp($WoWEvent->time);
        $return = array(
            'comment' => $WoWEvent->comment,
            'datetime'=> $eventDateTime->getTimestamp(),
            'description'=> $WoWEvent->description,
            'canEdit'=> true,
            'icon'=> $WoWEvent->icon,
            'link'=> $WoWEvent->link,
            'name'=> $WoWEvent->name,
            'state'=> $WoWEvent->state,    
            'attendees' => $attendees,
            'group' => $group,
            'eventID' => $WoWEvent->eventID
            );
        return $return;

    }

    public function getEventWCLReportList() {
        $WoWEvent = new WoWEvent($this->getObjectIDs()[0]);
        $EventDate = new \DateTime();
        $EventDate->setTimestamp($WoWEvent->time);
        return  WCLAPI::getReportList($EventDate);
    }

    public function synchronizeWCL() {
        $attendees = null;
        $comment = StringUtil::trim($this->parameters['comment'] ?: '');
        $attendees = WCLAPI::convertReportToAttend($this->parameters['wclID']);
        $WoWEvent = new WoWEvent($this->objectIDs[0]);
        $comment .= '<a targe="_blank" href="https://www.warcraftlogs.com/reports/ '.$this->parameters['wclID'].'">Warcraft Logs</a><br/>' . $WoWEvent->comment;
        $WoWEventEditor = new WoWEventEditor($WoWEvent);
        $WoWEventEditor->preparecloseEvent($comment, $attendees);
    }

//$pointarray = array(
//    'pointCalc' => 'perEvent', // berechnungsgrundlage
//    'warningLimit' => -25, // Ab wievieln Punkten wird gewarnt?
//    'countIn' => 10, // wieviele Events bercksichtigen
//    'newMember' => 100, // neueMember starten bei X Punkten
//    'perEvent' => array(
//        0 => 20, // Wartepositiom
//        1 => 10, // Angemeldet und da
//        2 => 0, // Nicht dabei
//        3 => -5, //unbeantwortet
//        4 => -15, // nicht da
//    ),
//    'perEncounter' => array( // pro Encounter
//        0 => 10, // pro Kill
//        1 => 1, // pro Try
//    ),
//    'both' => array(
//        0 => 50, // Wartepositiom
//        1 => 10, // Angemeldet und da
//        2 => 0, // Nicht dabei
//        3 => -10, //unbeantwortet
//        4 => -50, // nicht da
//        5 => 10, // pro Kill
//        6 => 1, // pro Try
//    ),
//); 

    public function close() {
        $this->updateComment();
        $this->updatelink();
        $WoWEvent = new WoWEvent($this->objectIDs[0]);
        if ($WoWEvent->eventGroup->countAttend==1) {
            $WoWEventAttendList = new WoWEventAttendList();
            $WoWEventAttendetList = $WoWEventAttendList->getByEventID($WoWEvent->eventID);
            $pointarray = unserialize($WoWEvent->eventGroup->pointarray);
            $time = new \DateTime();
            $timeoffset = empty($pointarray['countIn']) ? 0 : $time->modify($pointarray['countIn']);
            if ($pointarray['pointCalc']=='perEvent') {
                foreach($WoWEventAttendetList as $WoWEventAttender) {
                    if (WoWCharacterPoint::getTotalEntrys($WoWEventAttender->charID, $timeoffset)==0) {
                        WoWCharacterPoint::recieveForEvent($WoWEventAttender->charID, $WoWEvent->eventID, $pointarray['newMember']);
                    } 
                    else { 
                        if ($WoWEventAttender->state==6 ) $points = $pointarray['perEvent'][3];
                        elseif ($WoWEventAttender->state==5 && $WoWEventAttender->attended==0) $points = $pointarray['perEvent'][2];
                        elseif ($WoWEventAttender->state==5 && $WoWEventAttender->attended==1) $points = $pointarray['perEvent'][1];
                        elseif ($WoWEventAttender->state==4 && $WoWEventAttender->attended==0) $points = $pointarray['perEvent'][2];
                        elseif ($WoWEventAttender->state==4 && $WoWEventAttender->attended==1) $points = $pointarray['perEvent'][1];
                        elseif ($WoWEventAttender->state==3 && $WoWEventAttender->attended==0) $points = $pointarray['perEvent'][0];
                        elseif ($WoWEventAttender->state==3 && $WoWEventAttender->attended==1) $points = $pointarray['perEvent'][1];
                        elseif ($WoWEventAttender->state==2 && $WoWEventAttender->attended==0) $points = $pointarray['perEvent'][4];
                        elseif ($WoWEventAttender->state==2 && $WoWEventAttender->attended==1) $points = $pointarray['perEvent'][1];
                        elseif ($WoWEventAttender->state==1 && $WoWEventAttender->attended==0) $points = $pointarray['perEvent'][4];
                        elseif ($WoWEventAttender->state==1 && $WoWEventAttender->attended==1) $points = $pointarray['perEvent'][1];
                        else  $points = 0;
                        WoWCharacterPoint::recieveForEvent($WoWEventAttender->charID, $WoWEvent->eventID, $points);
                    }
                }
            }
        }
        $eventAction = new WoWEventAction($this->objectIDs, 'update', array(
                'data' => array(
                    'state' => 4
                )
            ));
        $eventAction->executeAction();

    }


    public function toggleLock() {
        $WoWEvent = new WoWEvent($this->getObjectIDs()[0]);
        if ($WoWEvent->state == 2 || $WoWEvent->state == 1) {
            $newState = ($WoWEvent->state == 2) ? 1: 2;
            $eventAction = new WoWEventAction($this->objectIDs, 'update', array(
                    'data' => array(
                        'state' => $newState
                    )
                ));
            $eventAction->executeAction();
            $this->event->rebuild();
            return $newState;
        }
        else {
            return -1;
        }
    }

    public function updateComment() {
        $comment = StringUtil::trim($this->parameters['comment'] ?: $this->comment);
        $eventAction = new WoWEventAction($this->objectIDs, 'update', array(
                'data' => array(
                    'comment' => $comment
                )
            ));
        $eventAction->executeAction();
    }

    public function updatelink() {
        $link = StringUtil::trim($this->parameters['link'] ?: $this->link);
        $eventAction = new WoWEventAction($this->objectIDs, 'update', array(
                'data' => array(
                    'link' => $link
                )
            ));
        $eventAction->executeAction();
        return array(
            'link' => $link);
    }

    public function delete() {
        $eventAction = new WoWEventAction($this->objectIDs, 'update', array(
                'data' => array(
                    'sate' => 0
                )
            ));
        $eventAction->executeAction();
    }

}
