<?php
namespace wcf\data\wow\character;
use wcf\data\DatabaseObjectEditor;
use wcf\system\wow\BNETAsset;
use wcf\data\user\User;
use wcf\data\user\UserEditor;


/**
 * Provides functions to edit a WoW Character.
 * 
 * @author	Veneanar Falkenbann
 * @copyright	2015 Sylvanas Garde
 * @package	com.sylvanasgarde.tools
 * @subpackage	system.BNET
 * @category	Guild Tools
 */
class WoWCharacterEditor extends DatabaseObjectEditor {

    /**
     * @see wcf\data\DatabaseObjectDecorator::$baseClass
     */
    protected static $baseClass = 'wcf\data\wow\character\WoWCharacter';

    /**
     * Create a Character from Arsenal. 
     * Praam $bnetdata see BNETAPI::getCharacterDetails() for parameter example
     * returns a new WoWCharacter object
     * see wcf\sgt\bnet\WoWCharacter
     * 
     * @param array
     * @return \wcf\data\wow\character\WoWCharacter
     */
    public static function createFromBNET($bnetdata) {
        $guildname = (empty($bnetdata['guild']['name'])) ? empty($bnetdata['guild']) ? "": $bnetdata['guild']: $bnetdata['guild']['name'];
        $insert = array(
					'charname' => $bnetdata['name'],
					'realmname' => $bnetdata['realm'], 
					'class' => $bnetdata['class'], 
					'race' => $bnetdata['race'], 
					'gender' => $bnetdata['gender'],  
					'level' => $bnetdata['level'],  
					'avatar' => GUILDTOOL_BNET_API_SAVEASSET ?  BNETAsset::download('http://eu.battle.net/static-render/eu/' . $bnetdata['thumbnail']) : 'http://eu.battle.net/static-render/eu/' . $bnetdata['thumbnail'],  
					'userID' => 0,
					'inguild'=> ($guildname==GUILDTOOL_GUILD_NAME) ? 1: 0, 
					'isMain' => 0,
                    'rank' => empty($bnetdata['rank']) ? 10: $bnetdata['rank'],
                    'achievementPoints' => empty($bnetdata['achievementPoints']) ? 0: $bnetdata['achievementPoints'],
            );
        return self::create($insert);
    }

    /**
     * Updaets a Character from Arsenal. 
     * Praam $bnetdata see BNETAPI::getCharacterDetails() for parameter example
     * 
     * @param array
     */
    public function updateFromBNET($bnetdata) {
        $guildname = (empty($bnetdata['guild']['name'])) ? empty($bnetdata['guild']) ? "": $bnetdata['guild']: $bnetdata['guild']['name'];
        $update = array(
					'class' => $bnetdata['class'], 
					'race' => $bnetdata['race'], 
					'gender' => $bnetdata['gender'],  
					'level' => $bnetdata['level'],  
					'avatar' => GUILDTOOL_BNET_API_SAVEASSET ?  BNETAsset::download('http://eu.battle.net/static-render/eu/' . $bnetdata['thumbnail']) : 'http://eu.battle.net/static-render/eu/' . $bnetdata['thumbnail'],  
					'inguild'=> ($guildname==GUILDTOOL_GUILD_NAME) ? 1: 0, 
                    'achievementPoints' => empty($bnetdata['achievementPoints']) ? 0: $bnetdata['achievementPoints'],
        );
        if (!empty($bnetdata['rank'])) $update['rank'] = $bnetdata['rank'];
        self::update($update);
    }

    public function setMain() {
        if ($this->userID != 0) {
            $mainList = new WoWCharacterList();
            $mainList->getConditionBuilder()->add('userID = ? AND isMain = 1', array($this->userID));
            $mainList->readObjects();
            $mainListArray = $mainList->getObjects();
            foreach($mainListArray as $char) {
                $charEdit = new WoWCharacterEditor($char);
                $charEdit->update(array(
                    'isMain' => 0
                    ));
            }
        }
        self::update(array(
            'isMain' => 1
            ));
    }
}
 