<?php
namespace wcf\system\dashboard\box;
use \wcf\data\dashboard\box\DashboardBox;
use \wcf\page\IPage;
use \wcf\system\cache\builder\WoWNextEventsCacheBuilder;
use wcf\system\exception\SystemException;

use \wcf\system\WCF;

/**
 * Dashboardbox for the Events.
 * 
 * @author	    Veneanar
 * @copyright	2015 Sylvanas Garde
 * @package	    com.sylvanasgarde.guildtool
 * @category	Guild Tool
 */

class WoWnextEventsSidebarDashboardBox extends AbstractSidebarDashboardBox {
	/**
     * events
     * @var		array
     */
	protected $eventList = null;
	
	/**
     * @see		\wcf\system\dashboard\box\IDashboardBox::init()
     */
	public function init(DashboardBox $box, IPage $page) {
		parent::init($box, $page);
		$this->eventList  =  WoWNextEventsCacheBuilder::getInstance()->getData();
        $this->fetched();
	}
	
	/**
     * @see		\wcf\system\dashboard\box\AbstractContentDashboardBox::render()
     */
	protected function render() {
		if (!empty($this->eventList )) {
			return WCF::getTPL()->fetch('dashboardBoxWoWNextEventsSidebar', 'wcf', array(
				'nextEventList' => $this->eventList 
			));
		}
        else {
            return null;
        }
	}
}