<?php
namespace wcf\system\dashboard\box;
use \wcf\data\dashboard\box\DashboardBox;
use \wcf\page\IPage;
use \wcf\system\cache\builder\WoWRealmStateCacheBuilder;
use wcf\system\exception\SystemException;
use \wcf\system\WCF;

/**
 * Dashboardbox for the Realmstatus.
 * 
 * @author	    Veneanar
 * @copyright	2015 Sylvanas Garde
 * @package	    com.sylvanasgarde.guildtool
 * @category	Guild Tool
 */
class WoWRealmStateDashboardbox extends AbstractContentDashboardBox {
	/**
     * realms
     * @var		array
     */
	protected $realmdata = null;
	
	/**
     * @see		\wcf\system\dashboard\box\IDashboardBox::init()
     */
	public function init(DashboardBox $box, IPage $page) {
		parent::init($box, $page);
		$this->realmdata =  WoWRealmStateCacheBuilder::getInstance()->getData();
		$this->fetched();
	}
	
	/**
     * @see		\wcf\system\dashboard\box\AbstractContentDashboardBox::render()
     */
	protected function render() {
		if (!empty($this->realmdata)) {
			return WCF::getTPL()->fetch('dashboardBoxWoWRealmState', 'wcf', array(
				'realmStateList' => $this->realmdata
			));
		}
        else {
            throw new SystemException('no realm data');
        }
	}
}
