<?php
namespace wcf\system\cache\builder;
use \wcf\data\wow\character\WoWCharacterList;

/**
 * Provides realm status
 * 
 * @author	Veneanar Falkenbann
 * @copyright	2015 Sylvanas Garde
 * @package	com.sylvanasgarde.tools
 * @subpackage	system.BNET
 * @category	Guild Tools
 */

class WoWNewMemberCacheBuilder extends AbstractCacheBuilder {
	/**
     * @see		\wcf\system\cache\builder\AbstractCacheBuilder::$maxLifetime
     */
	protected $maxLifetime = 120;
	
	/**
     * @see		\wcf\system\cache\builder\AbstractCacheBuilder::rebuild()
     */
	protected function rebuild(array $parameters) {
        $WoWCharList = new WoWCharacterList();
        $WoWCharList->getConditionBuilder()->add('rank < 9');
        $WoWCharList->getConditionBuilder()->add('inGuild = 1');
        $WoWCharList->sqlOrderBy ='charID DESC';
        $WoWCharList->sqlLimit = 1;
        $WoWCharList->readObjects();
		return $WoWCharList->getObjects();
	}
}
