<?php
namespace wcf\system\cache\builder;
use \wcf\data\wow\group\WoWGroupList;

/**
 * Provides realm status
 * 
 * @author	Veneanar Falkenbann
 * @copyright	2015 Sylvanas Garde
 * @package	com.sylvanasgarde.tools
 * @subpackage	system.BNET
 * @category	Guild Tools
 */

class WoWGroupOverviewCacheBuilder extends AbstractCacheBuilder {
	/**
     * @see		\wcf\system\cache\builder\AbstractCacheBuilder::$maxLifetime
     */
	protected $maxLifetime = 120;
	
	/**
     * @see		\wcf\system\cache\builder\AbstractCacheBuilder::rebuild()
     */
	protected function rebuild(array $parameters) {
        $WoWCharList = new WoWGroupList();
        $WoWCharList->getConditionBuilder()->add('(publish = 1');
        $WoWCharList->sqlOrderBy ='name ASC';
        $WoWCharList->readObjects();
		return $WoWCharList->getObjects();
	}
}
