<?php
namespace wcf\system\bbcode;
use wcf\util\StringUtil;

class WoWPlayerBBCode extends AbstractBBCode {
	/**
	 * @see	\wcf\system\bbcode\IBBCode::getParsedTag()
	 */
	public function getParsedTag(array $openingTag, $content, array $closingTag, BBCodeParser $parser) {
		$url = 'http://www.domain.de/artikelnummer_%s_%s.html';
		$code = '';
		$referenz = 'WBB';
		
		if (isset($openingTag['attributes'][0])) {
			$code = preg_replace('/[^0-9a-z\/]+/i', '', $openingTag['attributes'][0]);
		}
		
		if (isset($openingTag['attributes'][1])) {
			$referenz = $openingTag['attributes'][1];
		}
		
		return StringUtil::getAnchorTag(sprintf($url, $code, $referenz), $content, false);
	}
}

