<?php
namespace wcf\form;
use wcf\data\user\User;
use wcf\system\WCF;
use wcf\util\HeaderUtil;
use wcf\system\request\LinkHandler;
use wcf\util\DateUtil;
use wbb\data\thread\ThreadAction;
use wbb\system\label\object\ThreadLabelObjectHandler;
use wcf\system\wow\WCLAPI;
use wbb\data\post\Post;


/**
 * Shows the Group details
 * 
 * 
 * @author	Veneanar Falkenbann
 * @copyright	2015 Sylvanas Garde
 * @package	com.sylvanasgarde.tools
 * @subpackage	system.BNET
 * @category	Guild Tools

 */

class GuildApplicationForm extends AbstractForm {
	/**
	 * @see	\wcf\page\AbstractPage::$activeMenuItem
	 */
    public $activeMenuItem = 'wcf.page.GuildTool.GuildApplication';

	public $templateName = 'guildApplication';
	/**
     * @see	\wcf\page\AbstractPage::$enableTracking
     */
	public $enableTracking = true;
	
    /**
     * application Char
     * @var	string
     */
	public $charname = '';
	
	/**
     * application Realm
     * @var	string
     */
	public $realm = '';

    /**
     * application battle tag
     * @var	string
     */
	public $btag = '';

    /**
     * application info
     * @var	string
     */
	public $info = '';

    /**
     * application rp text
     * @var	string
     */
	public $rptext= '';

    /**
     * application comment
     * @var	string
     */
	public $comment = '';
    /**
     * application labelIDs
     * @var	array
     */
	public $labelIDs = array();

	/**
	 * @see Form::readFormParameters()
	 */
	public function readFormParameters() {
		parent::readFormParameters();
        if (isset($_POST['Raidgruppe'])) $this->labelIDs[] = $_POST['Raidgruppe'];
        if (isset($_POST['guildapp']) && $_POST['guildapp']==1) {
            $this->labelIDs[] = 17;
        } else {
            if ($_POST['Raidgruppe'] !=17) $this->labelIDs[] = 1;
        }
        $this->labelIDs[] = (isset($_POST['guildapp']) && $_POST['guildapp']==1) ?  17 : 1;
        $this->role = isset($_POST['role']) ? $_POST['role'] : "DD";	
        $this->charname = isset($_POST['charname']) ? $_POST['charname'] : "Error";		
        $this->realm = isset($_POST['realm']) ? $_POST['realm'] : "Error";
        $this->btag = isset($_POST['btag']) ? $_POST['btag'] : "";	
        $this->info = isset($_POST['info']) ? $_POST['info'] : "";	
        $this->rptext = isset($_POST['rptext']) ? $_POST['rptext'] : "";
        $this->comment = isset($_POST['text']) ? $_POST['text'] : "";
    }
	
	/**
	 * @see	\wcf\form\IForm::validate()
	 */
	public function validate() {
		parent::validate();
        }
	/**
	 * @see Form::save()
	 */
	public function save() {
		parent::save();
        $wcl_reports = WCLAPI::getPlayerRanking($this->charname, $this->realm);
        $wcl_string = '';
        if (!empty($wcl_reports)) {
            $wcl_string .= "Warcraftlogs Rankings (letzte 10) \n[list=1]";
            $i = 0;
            foreach ($wcl_reports as $report) {
                $datetime = DateUtil::getDateTimeByTimestamp(intval(($report['startTime']) /1000));
                $wcl_string .= "[*][url='https://www.warcraftlogs.com/reports/".$report['reportID']."']" . DateUtil::format($datetime) .": Rang ". $report['rank'] ."/ ". $report['outOf'] . "[/url]";
                $i++;
                if($i==9) break;
            }        
            $wcl_string .= "[/list]\n\n";
        }
        $userid = intval(@WCF::getUser()->userID ?: 1);
        $Authour = new User(intval($userid));
        $lnkrealm = str_replace(" ", "-", 	$this->realm);
        $url = "http://eu.battle.net/wow/de/character/".$lnkrealm."/".$this->charname."/advanced";
        $msg = 
            "[b][url='".$url."']" . $this->charname . " / " . $this->realm . "[/url][/b] \n ". 
            $this->role . " ". $this->info ."\n\n" . 
            $this->btag . "\n" . 
            $this->comment ."\n\n" .
            $this->rptext .
            "\n\n [b]Information[/b] \n Arsenal-Link:[url]".$url."[/url]\n WoWPorgress: [url]http://www.wowprogress.com/character/eu/".$lnkrealm."/".$this->charname."[/url]\n".
            $wcl_string;
        // 4
        $data = array(
         'boardID' => 42,
         'languageID' => NULL,
         'topic' => $this->role . " ". $this->charname. " (". $this->info .")",
         'time' => TIME_NOW,
         'userID' => $userid,
         'username' => $Authour->username,
         'hasLabels' => 1
         );
        $threadData = array(
        'data' => $data,
        'attachmentHandler' => null,
        'postData' => array(
           'message' => $msg,
           'enableBBCodes' => 1,
           'enableHtml' => 0,
           'enableSmilies' => 1,
           'showSignature' => 1
        ),
        'tags' => array(),
        'subscribeThread' => 0
        );
        $objectAction = new ThreadAction(array(), 'create', $threadData);
        $resultValues = $objectAction->executeAction();
        if (!empty($this->labelIDs)) {
			ThreadLabelObjectHandler::getInstance()->setLabels($this->labelIDs, $resultValues['returnValues']->threadID);
		}

		$this->saved();
		
		if ($resultValues['returnValues']->isDisabled && !$this->board->getModeratorPermission('canEnableThread')) {
			HeaderUtil::delayedRedirect(LinkHandler::getInstance()->getLink('Board', array(
				'application' => 'wbb',
				'object' => $this->board
			)), WCF::getLanguage()->get('wbb.thread.moderation.redirect'), 30);
		}
		else {
			HeaderUtil::redirect(LinkHandler::getInstance()->getLink('Thread', array(
				'application' => 'wbb',
				'object' => $resultValues['returnValues']
			)));
		}
		exit;

	}
        
	/**
	 * @see Page::assignVariables()
	 */
	public function assignVariables() {
		parent::assignVariables();
        // Test 49
        $sylgaTextPost = new Post(11016);
        $sylgaText = $sylgaTextPost->getFormattedMessage();
        WCF::getTPL()->assign(array(
            'sylgaText' => $sylgaText
        ));

	}
}
