<?php
namespace wcf\data\wow\feed;
use wcf\system\exception\SystemException;
use wcf\data\DatabaseObject;
use wcf\system\WCF;
/**
 * Represents a WoW Achievment.
 * 
 * @author	Veneanar Falkenbann
 * @copyright	2015 Sylvanas Garde
 * @package	com.sylvanasgarde.tools
 * @subpackage	system.BNET
 * @category	Guild Tools
 */
class WoWACM extends DatabaseObject {
    /**
     * @see wcf\data\DatabaseObject::$databaseTableName
     */
    protected static $databaseTableName = 'guildtool_wowdata_acm';
    /**
     * @see wcf\data\DatabaseObject::$databaseTableIndexName
     */
    protected static $databaseTableIndexName = 'acmID';

    public static function create($acmdata) {
        if (empty($acmdata['id'])) {
            throw new SystemException('Data Error');
        }
        $acmTest = new WoWACM($acmdata['id']);
        if (intval($acmTest->getObjectID()) > 0) {
            return $acmTest;    
        } 
        else {
            $acm = array(
            'acmID' => $acmdata['id'],
            'title' => $acmdata['title'],
            'description' => $acmdata['description'],
            'icon' => $acmdata['icon'],
            'points' => $acmdata['points']
            );
            return WoWACMEditor::create($acm);
        }
    }
}