<?php
namespace wcf\data\wow\character;
use wcf\data\DatabaseObject;
use wcf\data\user\group\UserGroup;
use wcf\data\user\User;
use wcf\system\WCF;
use wcf\data\wow\group\WoWGroup;
/**
 * Represents a Pointtransaction.
 * 
 * @author	Veneanar Falkenbann
 * @copyright	2015 Sylvanas Garde
 * @package	com.sylvanasgarde.tools
 * @category	Guild Tools DKP
 * 
 * @property int $transID PRIMARY KEY
 * @property int $charID WoWCharacterID
 * @property int $eventID WoWEventID
 * @property int $lootID WoWLootID
 * @property int $amount positive or negative amount of points
 * @property int $issuerID WCF User ID if the transaction was mnaual
 * @property string $comment comment
 * @property int $time Timestamp
 * 
 * 
 */

class WoWCharacterPoint extends DatabaseObject {
    /**
     * @see wcf\data\DatabaseObject::$databaseTableName
     */
    protected static $databaseTableName = 'guildtool_points';
    /**
     * @see wcf\data\DatabaseObject::$databaseTableIndexName
     */
    protected static $databaseTableIndexName = 'transID';

    private $total = null;

    /**
     * function to count all points
     * 
     * @param integer $charID Character ID
     * @param integer $time timestamp
     * @return integer
     */
    private function getTotalPoints($charID, $time) {
        $sql = "SELECT	SUM(amount) AS total
			    FROM    ".$this->getDatabaseTableName()." ".$this->getDatabaseTableAlias() ."
                WHERE   charID = ? AND time >= ?";
		$statement = WCF::getDB()->prepareStatement($sql);
		$statement->execute(array($charID, $time));
		$row = $statement->fetchArray();
        return intval($row['total']);
    }
    /**
     * function to count all points
     * 
     * @param integer $charID Character ID
     * @param integer $time timestamp
     * @return integer
     */

    public function getTotalEntrys($charID, $time = 0) {
        $sql = "SELECT	COUNT(*) AS count
			    FROM    ".$this->getDatabaseTableName()." ".$this->getDatabaseTableAlias() ."
                WHERE   charID = ? AND time >= ?";
		$statement = WCF::getDB()->prepareStatement($sql);
		$statement->execute(array($charID, $time));
		$row = $statement->fetchArray();
        return intval($row['count']);
    }

        /**
     * Creates a point trasaction. 
     * recieve points for an event
     * 
     * @param integer $charID Character ID
     * @param integer $eventID Event ID
     * @param integer $amount amount of points
     * @return \wcf\data\wow\character\WoWCharacterPoint
     */
    static public function recieveForEvent($charID, $eventID, $amount) {
        $currentTimestamp = new \DateTime();
        $insert = array(
            'charID' => $charID,
            'eventID' => $eventID,
            'amount' => $amount,
            'issuerID' => 0,
            'time' => $currentTimestamp->getTimestamp()
        );
        return WoWCharacterPointEditor::create($insert);
    }

    static public function spentForItem($charID, $eventID, $lootID, $amount) {
        $currentTimestamp = new \DateTime();
        $insert = array(
            'charID' => $charID,
            'eventID' => $eventID,
            'lootID' => $lootID,
            'amount' => $amount,
            'issuerID' => 0,
            'time' => $currentTimestamp->getTimestamp()
        );
        return WoWCharacterPointEditor::create($insert);
    }

    static public function manuallTrasaction($charID, $amount, $comment) {
        $currentTimestamp = new \DateTime();
        $issuerID = WCF::getUser()->userID;
        $insert = array(
            'charID' => $charID,
            'amount' => $amount,
            'comment' => $comment,
            'issuerID' => $issuerID,
            'time' => $currentTimestamp->getTimestamp()
        );
        return WoWCharacterPointEditor::create($insert);
    }

}
