<?php
namespace wcf\data\wow;
use wcf\system\exception\SystemException;
use wcf\data\DatabaseObject;
use wcf\system\WCF;

/**
 * Represents a WoW Tokeninfo
 * 
 * @author	Veneanar Falkenbann
 * @copyright	2015 Sylvanas Garde
 * @package	com.sylvanasgarde.tools
 * @category	Guild Tools
 * 
 * @property-read int $price wow-token price in copper
 * @property-read int $low24 lowest wow-token price in copper in the last 24h
 * @property-read int $price highest wow-token price in copper in the last 24h
 * @property-read int $time UNIX timestamp, also the PRIMARY KEY
 * 
 * 
 */
class WoWToken extends DatabaseObject {
    /**
     * @see wcf\data\DatabaseObject::$databaseTableName
     */
    protected static $databaseTableName = 'guildtool_token';
    /**
     * @see wcf\data\DatabaseObject::$databaseTableIndexName
     */
    protected static $databaseTableIndexName = 'time';

    /**
     * get the latest token info
     * 
     * @return	\wcf\data\wow\WoWToken		
     */
    public static function getLast() {
        $sql = 'SELECT *
                FROM wcf'.WCF_N.'_guildtool_token
                ORDER BY time DESC 
                LIMIT 1';
		$statement = WCF::getDB()->prepareStatement($sql);
		$statement->execute();
		$row = $statement->fetchArray();
		if (!$row) $row = array();
		return new WoWToken(null, $row);
    }

    /**
     * create new token from array
     * 
     * @param array $tokendata 
     * @see \wcf\system\wow\WoWTokenInfo		
     */
    public static function create($tokendata) {
        if (empty($tokendata['time'])) {
            throw new SystemException('Data Error');
        }
        $tokenTest = new WoWToken($tokendata['time']);
        if (intval($tokenTest->getObjectID()) > 0) {
            return $tokenTest;    
        } 
        else {
            return WoWTokenEditor::create($tokendata);
        }
    }
}
