{include file='documentHeader'}
<head>
    <!--[if lte IE 8]>
    <style>
        /* Rotation of the arrow element for IE < 9 */
        .next-icon { /* IE Matrix Calculator - http: //www.boogdesign.com/examples/transforms/matrix-calculator.html */;
            -ms-filter: "progid:DXImageTransform.Microsoft.Matrix(M11=0.70710678, M12=-0.70710678, M21=0.70710678, M22=0.70710678,sizingMethod='auto expand')";
            filter: progid:DXImageTransform.Microsoft.Matrix(M11=0.70710678, M12=-0.70710678, M21=0.70710678, M22=0.70710678,sizingMethod='auto expand');
        }
    </style>
    <![endif]-->
    {literal}
	<style>
	#big-video-wrap{overflow:hidden;position:fixed;height:100%;width:100%;top:0;left:0;}
	#big-video-vid,#big-video-image{position:absolute;}
	#big-video-control-container{position:fixed;bottom:20px;padding: 0 20px;width:100%;
	  -webkit-transition-duration:0.6s;-moz-transition-duration:0.6s;-ms-transition-duration:0.6s;-o-transition-duration:0.6s;transition-duration:0.6s;}
	#big-video-control{width:100%;height:16px;position:relative;}
	#big-video-control-middle{margin: 0 56px 0 24px;}
	#big-video-control-bar{width:100%;height:16px;position:relative;cursor:pointer;}
	#big-video-control-progress{position:absolute;top:7px;height:3px;width:0%;background:#fff;}
	#big-video-control-track{position:absolute;top:8px;height:1px;width:100%;background:#fff;}
	#big-video-control-bound-left{left:0;}
	#big-video-control-bound-right{right:-1px}
	#big-video-control-track .ui-slider-handle {opacity:0;}
	#big-video-control-playhead{left:30%;}
	#big-video-control-play{position:absolute;top:0;left:0;height:16px;width:16px;background-image:url('bigvideo.png');}
	#big-video-control-timer{position:absolute;top:1px;right:0;color:#fff;font-size:11px;}
	#big-video-control-playhead,#big-video-control-bound-left,#big-video-control-bound-right{position:absolute;top:0;height:16px;width:1px;background:#fff;}
	#big-video-control .ui-slider-handle{border-left:solid 1px #fff; width:16px;height:16px;position:absolute;top:-8px;}
	.transparent{-ms-filter:"progid:DXImageTransform.Microsoft.Alpha(Opacity=0)";filter:alpha(opacity=0);-moz-opacity:0;-khtml-opacity:0;opacity:0;}
	.vjs-big-play-button{display:none !important;}

	
    html,
    body {
        margin: 0;
        padding: 0;
        overflow: hidden;
		background:none;
    }
    
    .wrapper {
        margin-top:130px;
        position: relative;
        width: 500%;
        height: 100%;
        z-index: 0;
    }
    
    /* Text */
    
    .video-title {
        margin: 0;
        padding: 0;
        text-shadow: 1px 1px 1px rgba(0,0,0,.5);
        color: #fff;
    }
    
    .video-title a,
    .video-title a:hover,
    .video-title a:visited {
        text-decoration: none;
    }
    
    
    
    /* Header */
    
    .vidtext {
        position: absolute;
        top: 30%;
        left: 50%;
        z-index: 999;
        color: #fff;
        background: rgba(0,0,0,0.5);
        padding: 60px;
        width: 400px;
        height: 400px;
        border-radius: 50%;
        margin: -200px 0 0 -200px;
        text-align: center;
    }
    
    .vidtext h1 {
        box-shadow: 0 1px 0 rgba(255, 255, 255, 0.1);
        padding: 0 0 10px 0;
        font-size: 1.7em;
        border-bottom: 1px solid rgba(0, 0, 0, 0.8);
    }
    
    .vidtext h1 span {
        font-weight: 300;
    }
    
    .vidtext p {
        font-family: Cambria, Georgia, serif;
        font-style: italic;
    }
    
    /* Video Pages */
    
    .screen {
        position: relative;
        height: 100%;
        width: 20%; /*  NOTE: numVideos/100%  */;
        float: left;
        overflow: hidden;
    }
    
    .big-image {
        min-width: 100%;
        min-height: 100%;
        height: auto;
        width: auto;
    }
    
    .video-title {
        position: absolute;
        top: 5%;
        right: 5%;
        opacity: .5;
        margin: 40px 0 0 0;
        padding: 0;
        line-height: .65;
        font-size: 4em;
        text-transform: uppercase;
    }
    
    /* Nav */
    
    #next-btn {
        position: absolute;
        right: 5%;
        top: 45%;
        padding: 20px;
        background: #000;
        border-radius: 40px;
        opacity: .4;
        cursor: pointer;
        z-index: 1000;
    }
    
    #next-btn:hover {
        opacity: .6;
    }
    
    .next-icon {
        display: block;
        border-top: solid 2px #fff;
        border-right: solid 2px #fff;
        width: 20px;
        height: 20px;
        position: relative;
        left: -5px;
        -webkit-transform: rotate(45deg);
        -moz-transform: rotate(45deg);
        -ms-transform: rotate(45deg);
        -o-transform: rotate(45deg);
        transform: rotate(45deg);
        color: #fff;
        text-decoration: none;
    }
    </style>
    {/literal}
	<title>{lang}wcf.page.tourtool.tour.title{/lang} - {PAGE_TITLE|language}</title>
	{include file='headInclude' sandbox=false}
    <script src="/js/jquery.imagesloaded.min.js" data-relocate="true"></script>
    <script src="/js/video.js" data-relocate="true"></script>
    <script src="/js/bigvideo.js" data-relocate="true"></script>
    <script src="/js/jquery.transit.min.js" data-relocate="true"></script>
    <script src="/js/modernizr-2.5.3.min.js" data-relocate="true"></script>
</head>

<body>
{include file='mainMenu'}
    <div class="wrapper">
        <div class="screen" id="screen-1" data-video="images/film_blatt.mp4">
            <img src="images/film_blatt.jpg" class="big-image" />
            <h1 class="video-title">#1 Unser Hof</h1>
            <div class="vidtext">
                <h1>Ruf Meckelfeld </h1>
                <p>Am Rande Hamburgs schnell zu erreichen aber wunderschön in der Natur gelegen. Das Video im Hintergrund zeigt eine Aufnahme des Hofes (evtl. in Zeitraffer?) Kein Ton. </p>
				<p>Lorem ipsum dolor sit amet, consetetur sadipscing elitr, sed diam nonumy eirmod tempor invidunt ut labore et dolore magna aliquyam erat, sed diam voluptua. At vero eos et accusam et justo duo dolores et ea rebum.</p>
            </div>            
        </div>
        <div class="screen" id="screen-2" data-video="images/film_natur.mp4">
            <img src="images/film_natur.jpg" class="big-image" />
            <h1 class="video-title">#2 Springreiten</h1>
            <div class="vidtext">
                <h1>Hier kann man alles lernen!!</h1>
                <p>Geeignet für jung und alt, in der Gruppe oder einzeln. Auch sportlichere Stile wie Naturspringreiten Dressurreiten blablub.</p>
                <p>Das Video im Hintergrund zeigt eine der verschiedenen Reitstile die man lernen kann. Diese Seite hier sollte für Halle, Dressurreiten, etc. ebenfalls erstellt werden. Man muss sofort Lsut bekommen das auch zu lernen.</p>
            </div>
        </div>
        <div class="screen" id="screen-3" data-video="images/film_halle.mp4">
            <img src="images/film_halle.jpg" class="big-image" />
            <h1 class="video-title">#3 Dresurreiten</h1>
            <div class="vidtext">
                <h1>Auch in der Halle</h1>
                <p>Geeignet für jung und alt, in der Gruppe oder einzeln. Auch sportlichere Stile wie Naturspringreiten Dressurreiten blablub.</p>
                <p>Das Video im Hintergrund zeigt eine der verschiedenen Reitstile die man lernen kann. Diese Seite hier sollte für Halle, Dressurreiten, etc. ebenfalls erstellt werden. Man muss sofort Lsut bekommen das auch zu lernen.</p>
            </div>
        </div>
        <div class="screen" id="screen-4" data-video="images/film_weide.mp4">
            <img src="images/film_weide.jpg" class="big-image" />
            <h1 class="video-title">#4 Weide</h1>
            <div class="vidtext">
                <h1>Das Wohl der Tiere ist wichtig!</h1>
                <p>Große Weiden kontrollierte Ruhezeiten artgerechte Nahrung, liebevolle Pflege... ökologische Verantwortung tralalala</p>
                <p>Ein Tierliebhaber muss bei dem Video weich werden. </p>
            </div>
        </div>
        <div class="screen" id="screen-5" data-video="images/film_regen.mp4">
            <img src="images/film_regen.jpg" class="big-image" />
            <h1 class="video-title">#5 Stall</h1>
            <div class="vidtext">
                <h1>Pflege und Verantwortung</h1>
                <p>Wir bieten den Schülerinnen auch an im Stall zu helfen, so lernt man Verantwortung zu übernehmen. Auch berufstätige oder Reiterinnen mit Familien, die weniger zeit aufbringen können profitieren: unser Personal sorgt sich um jedes Tier </p>            </div>
        </div>
    </div>

    <div id="next-btn">
        <span class="next-icon"></span>
    </div>
{literal}
<script data-relocate="true">
        $(function() {

            // Use Modernizr to detect for touch devices, 
            // which don't support autoplay and may have less bandwidth, 
            // so just give them the poster images instead
            var screenIndex = 1,
                numScreens = $('.screen').length,
                isTransitioning = false,
                transitionDur = 1000,
                BV,
                videoPlayer,
                isTouch = Modernizr.touch,
                $bigImage = $('.big-image'),
                $window = $(window);
            
            if (!isTouch) {
                // initialize BigVideo
                BV = new $.BigVideo({forceAutoplay:isTouch});
                BV.init();
                showVideo();
                
                BV.getPlayer().addEvent('loadeddata', function() {
                    onVideoLoaded();
                });

                // adjust image positioning so it lines up with video
                $bigImage
                    .css('position','relative')
                    .imagesLoaded(adjustImagePositioning);
                // and on window resize
                $window.on('resize', adjustImagePositioning);
            }
            
            // Next button click goes to next div
            $('#next-btn').on('click', function(e) {
                e.preventDefault();
                if (!isTransitioning) {
                    next();
                }
            });

            function showVideo() {
                BV.show($('#screen-'+screenIndex).attr('data-video'),{ambient:true});
            }

            function next() {
                isTransitioning = true;
                
                // update video index, reset image opacity if starting over
                if (screenIndex === numScreens) {
                    $bigImage.css('opacity',1);
                    screenIndex = 1;
                } else {
                    screenIndex++;
                }
                
                if (!isTouch) {
                    $('#big-video-wrap').transit({'left':'-100%'},transitionDur)
                }
                    
                (Modernizr.csstransitions)?
                    $('.wrapper').transit(
                        {'left':'-'+(100*(screenIndex-1))+'%'},
                        transitionDur,
                        onTransitionComplete):
                    onTransitionComplete();
            }

            function onVideoLoaded() {
                $('#screen-'+screenIndex).find('.big-image').transit({'opacity':0},500)
            }

            function onTransitionComplete() {
                isTransitioning = false;
                if (!isTouch) {
                    $('#big-video-wrap').css('left',0);
                    showVideo();
                }
            }

            function adjustImagePositioning() {
                $bigImage.each(function(){
                    var $img = $(this),
                        img = new Image();

                    img.src = $img.attr('src');

                    var windowWidth = $window.width(),
                        windowHeight = $window.height(),
                        r_w = windowHeight / windowWidth,
                        i_w = img.width,
                        i_h = img.height,
                        r_i = i_h / i_w,
                        new_w, new_h, new_left, new_top;

                    if( r_w > r_i ) {
                        new_h   = windowHeight;
                        new_w   = windowHeight / r_i;
                    }
                    else {
                        new_h   = windowWidth * r_i;
                        new_w   = windowWidth;
                    }

                    $img.css({
                        width   : new_w,
                        height  : new_h,
                        left    : ( windowWidth - new_w ) / 2,
                        top     : ( windowHeight - new_h ) / 2
                    })

                });

            }
        });
</script>
{/literal}    
<footer>
<!-- JAVASCRIPT_RELOCATE_POSITION -->

{@FOOTER_CODE}

<a id="bottom"></a>
</footer>
</body>
</html>