{include file='documentHeader'}

<head>
	<title>Ratssitzungsprotokoll erstellen</title>
	
	{include file='headInclude'}
	
	<script data-relocate="true">
		//<![CDATA[
	
		$(function() {
			WCF.Language.addObject({
				'wcf.message.bbcode.code.copy': '{lang}wcf.message.bbcode.code.copy{/lang}'
			});
			
			WCF.Message.Submit.registerButton('text', $('#messageContainer > .formSubmit > input[type=submit]'));
			new WCF.Message.FormGuard();
			new WCF.Message.BBCode.CodeViewer();
			
			WCF.System.Dependency.Manager.register('CKEditor', function() { new WCF.Message.UserMention('nextAgendaContent'); });
			WCF.System.Dependency.Manager.register('CKEditor', function() { new WCF.Message.UserMention('internalReport'); });
			WCF.System.Dependency.Manager.register('CKEditor', function() { new WCF.Message.UserMention('publicReport'); });
			
			$("#internalReport").keyup(function() {
				$("#publicReport").val( this.value );
			});			
		});
		//]]>
	</script>
</head>

<body id="tpl{$templateName|ucfirst}">
{include file='header'}

<header class="boxHeadline">
	<h1>{lang}wbb.post.edit{/lang}</h1>
</header>

{include file='userNotice'}

{include file='formError'}

<form id="messageContainer" class="jsFormGuard" method="post" action="">
	<div class="container containerPadding marginTop">
		<fieldset>
			<legend>neues Protokoll erstellen</legend>
			<dl{if $errorField == 'subject'} class="formError"{/if}>
				<dt><label for="reportTitle">{lang}wbb.post.subject{/lang}</label></dt>
				<dd>
					<input type="text" id="reportTitle" name="reportTitle" value="{$reportTitle}" maxlength="255" class="long" />
					{if $errorField == 'subject'}
						<small class="innerError">
							{if $errorType == 'empty'}
								{lang}wcf.global.form.error.empty{/lang}
							{elseif $errorType == 'censoredWordsFound'}
								{lang}wcf.message.error.censoredWordsFound{/lang}
							{else}
								{lang}wbb.post.subject.error.{@$errorType}{/lang}
							{/if}
						</small>
					{/if}
				</dd>
			</dl>	
			<dl>
				<dt>
                	<label for="Agenda">Sitzung auswählen</label>
                </dt>
				<dd>
                    <select name="threadID" id="threadID" class="long">
                    {foreach from=$threads item=$thread}
                        <option value="{$thread->threadID}">{$thread->topic}</option>
                    {/foreach}
                    </select>
				</dd>
			</dl>	            		
			<dl class="{if $errorField == 'text'} formError{/if}">
			  <dt>
			    <label for="text">Protokoll (Verwende "//" am Zeilenanfang für interne Informationen):</label></dt>
				<dd>
				  <textarea rows="20" cols="40" id="internalReport" name="internalReport">{$reportTemplate}</textarea>{if $errorField == 'text'}
						<small>Um interne Informationen zu kennzeichnen, am Zeilenanfang // schreiben. Diese Zeile kommt dann nicht in die öffentliche Protokollversion.</small>
                        <small class="innerError">
							{if $errorType == 'empty'}
								{lang}wcf.global.form.error.empty{/lang}
							{elseif $errorType == 'tooLong'}
								{lang}wcf.message.error.tooLong{/lang}
							{elseif $errorType == 'censoredWordsFound'}
								{lang}wcf.message.error.censoredWordsFound{/lang}
							{elseif $errorType == 'disallowedBBCodes'}
								{lang}wcf.message.error.disallowedBBCodes{/lang}
							{else}
								{lang}wbb.post.message.error.{@$errorType}{/lang}
							{/if}
						</small>
					{/if}
				</dd>
			</dl>

            <dl{if $errorField == 'subject'} class="formError"{/if}>
				<dt><label for="subject">Betreff Agenda:</label></dt>
				<dd>
					<input type="text" id="nextAgendaTitle" name="nextAgendaTitle" value="{$nextAgendaTitle}" maxlength="255" class="long" />
					{if $errorField == 'subject'}
						<small class="innerError">
							{if $errorType == 'empty'}
								{lang}wcf.global.form.error.empty{/lang}
							{elseif $errorType == 'censoredWordsFound'}
								{lang}wcf.message.error.censoredWordsFound{/lang}
							{else}
								{lang}wbb.post.subject.error.{@$errorType}{/lang}
							{/if}
						</small>
					{/if}
				</dd>
			</dl>
			<dl class="{if $errorField == 'text'} formError{/if}">
				<dt><label for="text">Agenda zur nächsten Sitzung</label></dt>
				<dd>
					<textarea rows="20" cols="40" id="nextAgendaContent" name="nextAgendaContent">{$agendaTemplate}</textarea>
					{if $errorField == 'text'}
						<small class="innerError">
							{if $errorType == 'empty'}
								{lang}wcf.global.form.error.empty{/lang}
							{elseif $errorType == 'tooLong'}
								{lang}wcf.message.error.tooLong{/lang}
							{elseif $errorType == 'censoredWordsFound'}
								{lang}wcf.message.error.censoredWordsFound{/lang}
							{elseif $errorType == 'disallowedBBCodes'}
								{lang}wcf.message.error.disallowedBBCodes{/lang}
							{else}
								{lang}wbb.post.message.error.{@$errorType}{/lang}
							{/if}
						</small>
					{/if}
				</dd>
			</dl>
            {event name='messageFields'}
		</fieldset>
		{event name='fieldsets'}
	</div>
	
	<div class="formSubmit">
		<input type="submit" value="{lang}wcf.global.button.submit{/lang}" accesskey="s" />
		{@SECURITY_TOKEN_INPUT_TAG}
	</div>
</form>
{include file='footer'}
{include file="wysiwyg" wysiwygSelector="internalReport"}
{include file="wysiwyg" wysiwygSelector="nextAgendaContent"}

</body>
</html>
