{include file='documentHeader'}

<head>
	<title>Bewerbung erstellen</title>
	
	{include file='headInclude'}
	

{literal}
<script data-relocate="true">
//<![CDATA[
function isValidBattleTag(tag)  {
	var pattern = new RegExp(/^\D.{2,11}#\d{4}$/);
	return pattern.test(tag);
}
$(function() {
	$("#msgwrongfaction").hide();
	$("#msgotherrealm").hide();
	$("#action").hide();
	var EURealmlist = [
	"Aerie Peak",
	"Aggramar",
	"Alonsus",
	"Anachronos",
	"Arathor",
	"Aszune",
	"Azjol-Nerub",
	"Azuremyst",
	"Blade's Edge",
	"Bloodhoof",
	"Bronzebeard",
	"Bronze Dragonflight",
	"Chamber of Aspects",
	"Darkspear",
	"Doomhammer",
	"Draenor",
	"Dragonblight",
	"Emerald Dream",
	"Eonar",
	"Ghostlands",
	"Hellfire",
	"Hellscream",
	"Khadgar",
	"Kilrogg",
	"Kul Tiras",
	"Lightbringer",
	"Nagrand",
	"Nordrassil",
	"Quel'Thalas",
	"Runetotem",
	"Saurfang",
	"Shadowsong",
	"Silvermoon",
	"Stormrage",
	"Terenas",
	"Terokkar",
	"Thunderhorn",
	"Turalyon",
	"Vek'nilash",
	"Wildhammer",
	"Agamaggan",
	"Al'Akir",
	"Ahn'Qiraj",
	"Auchindoun",
	"Balnazzar",
	"Bladefist",
	"Bloodfeather",
	"Bloodscalp",
	"Boulderfist",
	"Burning Blade",
	"Burning Legion",
	"Burning Steppes",
	"Chromaggus",
	"Crushridge",
	"Daggerspine",
	"Darksorrow",
	"Deathwing",
	"Dentarg",
	"Dragonmaw",
	"Drak'thul",
	"Dunemaul",
	"Emeriss",
	"Executus",
	"Frostmane",
	"Frostwhisper",
	"Genjuros",
	"Grim Batol",
	"Haomarush",
	"Hakkar",
	"Jaedenar",
	"Karazhan",
	"Kazzak",
	"Kor'gall",
	"Laughing Skull",
	"Lightning's Blade",
	"Magtheridon",
	"Mazrigos",
	"Molten Core",
	"Neptulon",
	"Outland",
	"Ragnaros",
	"Ravencrest",
	"Shadowmoon",
	"Shattered Halls",
	"Shattered Hand",
	"Skullcrusher",
	"Spinebreaker",
	"Stonemaul",
	"Stormreaver",
	"Stormscale",
	"Sunstrider",
	"Sylvanas",
	"Talnivarr",
	"Tarren Mill",
	"The Maelstrom",
	"Trollbane",
	"Twilight's Hammer",
	"Twisting Nether",
	"Vashj",
	"Warsong",
	"Xavius",
	"Zenedar",
	"Argent Dawn",
	"Darkmoon Faire",
	"Earthen Ring",
	"Moonglade",
	"Steamwheedle Cartel",
	"The Sha'tar",
	"Defias Brotherhood",
	"Ravenholdt",
	"Scarshield Legion",
	"Sporeggar",
	"The Venture Co",
	"Chants éternels",
	"Dalaran",
	"Drek'Thar",
	"Eitrigg",
	"Elune",
	"Hyjal",
	"Khaz Modan",
	"Krasus",
	"Marécage de Zangar",
	"Medivh",
	"Suramar",
	"Uldaman",
	"Vol'jin",
	"Arak-arahm",
	"Arathi",
	"Archimonde",
	"Cho'gall",
	"Eldre'Thalas",
	"Garona",
	"Illidan",
	"Kael'Thas",
	"Naxxramas",
	"Ner'zhul",
	"Rashgarroth",
	"Sargeras",
	"Sinstralis",
	"Temple noir",
	"Throk'Feroth",
	"Varimathras",
	"Ysondre",
	"Confrérie du Thorium",
	"Kirin Tor",
	"Les Clairvoyants",
	"Les Sentinelles",
	"Conseil des Ombres",
	"Culte de la Rive Noire",
	"La Croisade écarlate",
	"Alexstrasza",
	"Alleria",
	"Aman'Thul",
	"Ambossar",
	"Antonidas",
	"Area 52",
	"Arygos",
	"Baelgun",
	"Blackhand",
	"Dun Morogh",
	"Durotan",
	"Gilneas",
	"Kargath",
	"Khaz'goroth",
	"Lordaeron",
	"Lothar",
	"Madmortem",
	"Malfurion",
	"Malygos",
	"Nethersturm",
	"Norgannon",
	"Nozdormu",
	"Perenolde",
	"Proudmoore",
	"Rexxar",
	"Sen'jin",
	"Shattrath",
	"Teldrassil",
	"Thrall",
	"Tirion",
	"Ysera",
	"Aegwynn",
	"Anetheron",
	"Anub'arak",
	"Arthas",
	"Azshara",
	"Blackmoore",
	"Blackrock",
	"Blutkessel",
	"Dalvengyr",
	"Destromath",
	"Dethecus",
	"Echsenkessel",
	"Eredar",
	"Festung der Stürme",
	"Frostmourne",
	"Frostwolf",
	"Gorgonnash",
	"Gul'dan",
	"Kel'Thuzad",
	"Kil'Jaeden",
	"Krag'jin",
	"Mal'Ganis",
	"Mannoroth",
	"Mug'thol",
	"Nathrezim",
	"Nazjatar",
	"Nefarian",
	"Nera'thor",
	"Onyxia",
	"Rajaxx",
	"Taerar",
	"Terrordar",
	"Theradras",
	"Tichondrius",
	"Un'Goro",
	"Vek'lor",
	"Wrathbringer",
	"Zuluhed",
	"Der Mithrilorden",
	"Der Rat von Dalaran",
	"Die Aldor",
	"Die ewige Wacht",
	"Die Nachtwache",
	"Die Silberne Hand",
	"Forscherliga",
	"Todeswache",
	"Zirkel des Cenarius",
	"Das Konsortium",
	"Das Syndikat",
	"Der abyssische Rat",
	"Die Arguswacht",
	"Die Todeskrallen",
	"Kult der Verdammten",
	"Colinas Pardas",
	"Exodar",
	"Minahonda",
	"Tyrande",
	"C'Thun",
	"Dun Modr",
	"Sanguino",
	"Uldum",
	"Zul'jin",
	"Los Errantes",
	"Shen'dralar",
	];
	$('#btag').on('input',function(e){
		if (isValidBattleTag($("#btag").val())) {
			$('#tagok').attr('src', '/img/ok.png');
		} else {
			$('#tagok').attr('src', '/img/fail.png');
		}
	});
		
	$("input[name='Raidgruppe']").change(function() {
		if($('#Raid_3').is(':checked')) { 
			$("#guildapp").prop( "checked", false );
			$("#guildapp").attr("disabled", true);
		} else {
			$("#guildapp").removeAttr("disabled");
		}
	});
	$("#realm").autocomplete({
		source: EURealmlist
	});
	$("#realm").focusout(function() {
		$("#charname").val("");
		$('#charok').attr('src', '/img/fail.png');
		//  || ($("#realm").val() != "Die Nachtwache") 
		if (($("#realm").val() == "Forscherliga") || ($("#realm").val()== "Die Nachtwache")) {
			$("#btagcaption").hide();
		} else {
			$("#btagcaption").show();
		}
	});
	$('#charname').on('input',function(e){
		$('#charok').attr('src', '/img/wait.gif');
		$.getJSON( "/api.php?sc="+$("#charname").val()+"&sr="+$("#realm").val(), function( json  ) {
			if (!json.name) {
				$("#action").hide();
				$("#msgotherrealm").hide();
				$("#msgwrongfaction").hide();
				$('#charok').attr('src', '/img/fail.png');
				$('#fail').text("Charakter nicht gefunden");
				$('#fail').css("color", "red");
			} else {
				var charrace = "";
				var charclass = "";
				var faction=0;
				switch (json.class) {
					case 1:
						charclass = "Krieger";
						break;
					case 2:
						charclass = "Paladin";
						break;
					case 3:
						charclass = "Jäger";
						break;
					case 4:
						charclass = "Schurke";
						break;
					case 5:
						charclass = "Priester";
						break;
					case 6:
						charclass = "Todesritter";
						break;
					case 7:
						charclass = "Schamane";
						break;		
					case 8:
						charclass = "Magier";
						break;
					case 9:
						charclass = "Hexenmeister";
						break;	
					case 10:
						charclass = "Mönch";
						break;
					case 11:
						charclass = "Druide";
						break;	
				}
				switch (json.race) {
					case 1:
						charrace = "Mensch";
						faction = 0;
						break;
					case 2:
						charrace = "Orc";
						faction = 1;
						break;
					case 3:
						charrace = "Zwerg";
						faction = 0;
						break;
					case 4:
						charrace = "Nachtelf";
						faction = 0;
						break;
					case 5:
						charrace = "Untoter";
						faction = 1;
						break;
					case 6:
						charrace = "Tauren";
						faction = 1;
						break;
					case 7:
						charrace = "Gnom";
						faction = 0;
						break;		
					case 8:
						charrace = "Troll";
						faction = 1;
						break;
					case 9:
						charrace = "Goblin";
						faction = 1;
						break;	
					case 10:
						charrace = "Blutelf";
						faction = 1;
						break;
					case 11:
						charrace = "Draenei";
						faction = 0;
						break;	
					case 22:
						charrace = "Worgen";
						faction = 0;
						break;
					case 25:
						charrace = "Pandaren";
						faction = 0;
						break;
					case 26:
						charrace = "Pandaren";
						faction = 1;
						break;							
				}
				var cstring = "Level "+ json.level + " "+ charrace + " " + charclass;
				if (faction==1) {
					$("#msgwrongfaction").hide();
					$('#fail').text(cstring);
					$('#charok').attr('src', '/img/ok.png')
					$('#fail').css("color", "green");
					$("#info").val(cstring);
					$("#subject").val($("#charname").val() + " / " +  $("#realm").val());
				}
				else {
					$('#fail').text(cstring);
					$('#charok').attr('src', '/img/fail.png');
					$('#fail').css("color", "red");
					$("#msgwrongfaction").show();
				}
			}
		});
	});	
});
//]]> 
</script>
<style>
.ui-autocomplete {
    position: absolute;
    top: 100%;
    left: 0;
    z-index: 1000;
    float: left;
    display: none;
    min-width: 160px;   
    padding: 4px 0;
    margin: 0 0 10px 25px;
    list-style: none;
    background-color: #ffffff;
    border-color: #ccc;
    border-color: rgba(0, 0, 0, 0.2);
    border-style: solid;
    border-width: 1px;
    -webkit-border-radius: 5px;
    -moz-border-radius: 5px;
    border-radius: 5px;
    -webkit-box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
    -moz-box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
    box-shadow: 0 5px 10px rgba(0, 0, 0, 0.2);
    -webkit-background-clip: padding-box;
    -moz-background-clip: padding;
    background-clip: padding-box;
    *border-right-width: 2px;
    *border-bottom-width: 2px;
}

.ui-menu-item > a.ui-corner-all {
    display: block;
    padding: 3px 15px;
    clear: both;
    font-weight: normal;
    line-height: 18px;
    color: #555555;
    white-space: nowrap;
    text-decoration: none;
}

.ui-state-hover, .ui-state-active {
    color: #c11616;
    text-decoration: none;
    background-color: #0088cc;
    border-radius: 0px;
    -webkit-border-radius: 0px;
    -moz-border-radius: 0px;
    background-image: none;
}

</style>
{/literal}
</script>
</head>

<body id="tpl{$templateName|ucfirst}">
{include file='header'}

<header class="boxHeadline">
  <h1>Bewerbung erstellen</h1>
</header>
{if $success|isset}
	<p class="success">{lang}wcf.global.success.{$action}{/lang}</p>
{/if}
{include file='userNotice'}

<div class="container containerPadding">
{@$sylgaText}
{include file='formError'}
<form id="sg2recruiter" name="sg2recruiter" method="post" action="" enctype="multipart/form-data">
	<fieldset>
	  <legend>Angaben zum Charakter</legend>
      <dl>
				<dt>
				  <label>Realm</label></dt>
				<dd>
				  <input name="realm" id="realm" type="text" class="medium" required/>
				</dd>                
			<dt>
			  <label>Name:</label></dt>
				<dd>
               	  <input name="charname" id="charname" type="text" class="medium" required>
                  <img id="charok" src="/img/fail.png" width="32" height="32" />
					<span id="fail"></span>
                    <small>Wenn du dich gezielt für einen Raid bewirbst, dann wähle Bitte den Charakter mit dem du gerne raiden möchtest</small>
				</dd>
        				<dt><label>Rolle: </label></dt>
				<dd>
					   	<select name="role" id="role" class="medium">
                  			<option value="DD" selected>Nah-/Fernkäpfer</option>
                  			<option value="Tank">Tank</option>
                  			<option value="Heiler">Heiler</option>

                  		</select>
 					<small>Nur erforderlich wenn du raiden möchtest. Wenn du mehr als eine Rolle aufüllen kannst und möchtest, schreibe dies bitte in den Kommentar</small>
				</dd>

	  </dl>	
      <dl>
	  <dt id="btagcaption"><label>BattleTag:</label></dt>
				<dd id="btagform">
                    	<input name="btag" id="btag" type="text" class="medium">
                        <img id="tagok" src="/img/fail.png" width="32" height="32" />
					<small>Optional, erleichtert die Kontaktaufnahme.</small>
				</dd>
      </dl>
	  <legend>Angaben zur Aufnahme</legend>      
	  <dl>
	  <dt id="btagcaption"><label>Bewerbung für:</label></dt>
				<dd id="btagform">
<table width="200">
  <tr>
    <td><label>
      <input type="radio" name="Raidgruppe" value="2" id="Raid_0">
      SG1</label></td>
  </tr>
  <tr>
    <td><label>
      <input type="radio" name="Raidgruppe" value="3" id="Raid_1">
      SG2</label></td>
  </tr>
  <tr>
    <td><label>
      <input type="radio" name="Raidgruppe" value="4" id="Raid_2">
      SG3</label></td>
  </tr>
  <tr>
    <td><label>
      <input name="Raidgruppe" type="radio" id="Raid_3" value="17" checked>
      nur Gilde</label></td>
  </tr>
</table>
<input name="guildapp" id="guildapp" type="checkbox" value="1" disabled="disabled"> Gildenbeitritt erwünscht
				</dd>
      </dl>  
      <dl>    
			<dt>kurze Vorstellung:</dt>
			<dd>
            	<textarea id="text" name="text" rows="10" ></textarea>
                <small>Arsenallink, WoWProgress Info und Log Rankings werden automatisch erstellt.</small>
			</dd>
       </dl>  
      <dl>             
			<dt>Rollenspiel Anschreiben (optional)</dt>
			<dd>
           	  <textarea id="rptext" name="rptext" rows="10"></textarea>
			</dd>            
	  </dl>
		</fieldset>
              
  <div class="formSubmit">
  <input name="info" id="info" type="hidden" value="1">
		<input type="submit" value="Absenden" accesskey="s" />
		{@SECURITY_TOKEN_INPUT_TAG}
  </div>
</form>
<p class="warning">Deine Bewerbung wird von einem Offizier geprüft und dann freigeschaltet, <b>du kannst vor der Freigabe deinen Beitrag weder sehen noch bearbeiten.</b> Du brauchst deine Nachricht also nicht mehrfach abzusenden falls sie nicht direkt angezeigt wird.</p>
</div>
{include file='footer'}
{include file="wysiwyg" wysiwygSelector="text"}
{include file="wysiwyg" wysiwygSelector="rptext"}

</body>
</html>