<?php
namespace wcf\util;
use wcf\system\exception\SystemException;
use wcf\system\WCF;
use wcf\util\StringUtil;
/**
 * The HTTPTools class is a wrapper for cURL.
 *  * 
 * @author	Veneanar
 * @copyright	2015 Sylvanas Garde
 * @package	com.sylvanasgarde.tools
 * @category	Guild Tools
 */
class HTTPTools {

    /**
     * UserAgent for crawling
     * @var	string
     */
    public static $userAgent = 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/44.0.2403.130 Safari/537.36';
    
    /**
     * Opens a website
     * 
     * return['status']  integer HTTP Code
     * return['content'] string body and header (if CURLOPT_HEADER=true)
     * @param	string		$uri
     * @param	array		$options
     * @return  array       (see obove)
     */
    protected static function open($uri, $options = array()) {
        $curloption = array(
            CURLOPT_URL => $uri,
            CURLOPT_RETURNTRANSFER => !empty($options[CURLOPT_RETURNTRANSFER]) ?: true,      
            CURLOPT_HEADER         => !empty($options[CURLOPT_HEADER]) ?: false,
            CURLOPT_FOLLOWLOCATION => !empty($options[CURLOPT_FOLLOWLOCATION]) ?: true,
            CURLOPT_ENCODING       => !empty($options[CURLOPT_ENCODING]) ?: "utf-8",
            CURLOPT_AUTOREFERER    => !empty($options[CURLOPT_AUTOREFERER]) ?: true,
            CURLOPT_SSL_VERIFYPEER => !empty($options[CURLOPT_SSL_VERIFYPEER]) ?: false,
            CURLOPT_CONNECTTIMEOUT => !empty($options[CURLOPT_CONNECTTIMEOUT]) ?: 120,  
            CURLOPT_TIMEOUT        => !empty($options[CURLOPT_TIMEOUT]) ?: 120,     
            CURLOPT_MAXREDIRS      => !empty($options[CURLOPT_MAXREDIRS]) ?: 10,       
            CURLOPT_USERAGENT      =>  static::$userAgent,
            CURLOPT_COOKIEFILE => 'coockie.txt',
            CURLOPT_COOKIEJAR => 'coockie.txt',
            );
        if (!empty($options)) $curloption = $curloption + $options;
        $curlObj = curl_init($uri);
        curl_setopt_array( $curlObj, $curloption );        
        $content = curl_exec( $curlObj );
        $httpCode = curl_getinfo($curlObj, CURLINFO_HTTP_CODE);
        curl_close( $curlObj );
        return array('status'=>intval($httpCode), 'content'=>$content);
    }

    /**
     * Downloads a ressource
     * 
     * @param	string		$uri uri of the ressource
     * @param   string      $path file to save ressource
     * @param	array		$options Optionarray see function curl-setopt
     */
    protected static function save($uri, $path, $option = array()) {
        @file_put_contents($path, fopen($uri, 'r'));
        if (filesize ($path) < 1024) {
            @unlink($path);
        }
        //echo '<br>url: ' .$uri;
        //$curloption = array(
        //    CURLOPT_URL => $uri,
        //    CURLOPT_RETURNTRANSFER => !empty($options['CURLOPT_RETURNTRANSFER']) ?: true,    
        //    CURLOPT_HEADER         => !empty($options['CURLOPT_HEADER']) ?: false,
        //    CURLOPT_FOLLOWLOCATION => !empty($options['CURLOPT_FOLLOWLOCATION']) ?: true,
        //    CURLOPT_ENCODING       => !empty($options['CURLOPT_ENCODING']) ?: "utf-8",
        //    CURLOPT_AUTOREFERER    => !empty($options['CURLOPT_AUTOREFERER']) ?: true,
        //    CURLOPT_SSL_VERIFYPEER => !empty($options['CURLOPT_SSL_VERIFYPEER']) ?: false,
        //    CURLOPT_BINARYTRANSFER => true,
        //    CURLOPT_USERAGENT      => static::$userAgent,
        //    CURLOPT_COOKIEFILE => 'coockie.txt',
        //    CURLOPT_COOKIEJAR => 'coockie.txt',
        //    );
        //if (!empty($options)) $curloption[] = $options;
        //$curlObj = curl_init($uri);
        //curl_setopt_array( $curlObj, $curloption );        
        //$raw=curl_exec($curlObj);
        //curl_close ($curlObj);
        //$httpCode=0;
        //$httpCode = @curl_getinfo($curlObj, CURLINFO_HTTP_CODE);
        //echo "CULR RETURN: ". $httpCode ."<br>";
        //if (intval($httpCode) ==200 ) {
        //    $fp = fopen($path,'w+');
        //    fwrite($fp, $raw);
        //    fclose($fp);        
        //}
    }
}