<?php
namespace wcf\system\wow;
use wcf\util\HTTPTools;
use wcf\system\exception\SystemException;
use wcf\system\WCF;
use wcf\util\StringUtil;
/**
 * The wowtoken.info API wrapper
 * 
 * @author	Veneanar
 * @copyright	2015 Sylvanas Garde
 * @package	com.sylvanasgarde.guildtool
 * @category	Guild Tools
 */
class WoWTokenInfo extends HTTPTools {
    
    /**
     * recieve a list of logs from a give date
     * return 
     * 
     * @return	array		
     */
    public static function getToken() {
        $webresult = self::open("https://wowtoken.info/wowtoken.json");
        if ($webresult['status'] != 200) throw new SystemException('wowtoken.info unrechable');
        $wowtoken = json_decode($webresult['content'], true);
        return array(
            'price' => $wowtoken["update"]["EU"]["raw"]["buy"], 
            'low24' => $wowtoken["update"]["EU"]["raw"]["24min"], 
            'high24' => $wowtoken["update"]["EU"]["raw"]["24max"], 
            'time' => $wowtoken["update"]["EU"]["raw"]["updated"]
        );    
    }
}