<?php
namespace wcf\system\dashboard\box;
use \wcf\data\dashboard\box\DashboardBox;
use \wcf\page\IPage;
use \wcf\system\cache\builder\WoWGroupOverviewCacheBuilder;
use wcf\system\exception\SystemException;

use \wcf\system\WCF;

/**
 * Dashboardbox for the Achievment Feeds.
 * 
 * @author	    Veneanar
 * @copyright	2015 Sylvanas Garde
 * @package	    com.sylvanasgarde.guildtool
 * @category	Guild Tool
 */

class WoWGroupOverviewDashboardBox extends AbstractContentDashboardBox {
	/**
     * realms
     * @var		array
     */
	protected $grouplist = null;
	
	/**
     * @see		\wcf\system\dashboard\box\IDashboardBox::init()
     */
	public function init(DashboardBox $box, IPage $page) {
		parent::init($box, $page);
		$this->grouplist  =  WoWGroupOverviewCacheBuilder::getInstance()->getData();
        $this->fetched();
	}
	
	/**
     * @see		\wcf\system\dashboard\box\AbstractContentDashboardBox::render()
     */
	protected function render() {
		if (!empty($this->feedList )) {
			return WCF::getTPL()->fetch('dashboardBoxWoWGroups', 'wcf', array(
				'groups' => $this->grouplist 
			));
		}
        else {
            return null;
        }
	}
}