<?php
namespace wcf\system\dashboard\box;
use \wcf\data\dashboard\box\DashboardBox;
use \wcf\page\IPage;
use \wcf\system\cache\builder\WoWFeedACMCacheBuilder;
use wcf\system\exception\SystemException;

use \wcf\system\WCF;

/**
 * Dashboardbox for the Achievment Feeds.
 * 
 * @author	    Veneanar
 * @copyright	2015 Sylvanas Garde
 * @package	    com.sylvanasgarde.guildtool
 * @category	Guild Tool
 */

class WoWFeedACMDashboardBox extends AbstractContentDashboardBox {
	/**
     * realms
     * @var		array
     */
	protected $feedList = null;
	
	/**
     * @see		\wcf\system\dashboard\box\IDashboardBox::init()
     */
	public function init(DashboardBox $box, IPage $page) {
		parent::init($box, $page);
		$this->feedList  =  WoWFeedACMCacheBuilder::getInstance()->getData();
        $this->fetched();
	}
	
	/**
     * @see		\wcf\system\dashboard\box\AbstractContentDashboardBox::render()
     */
	protected function render() {
		if (!empty($this->feedList )) {
			return WCF::getTPL()->fetch('dashboardBoxWoWFeedACM', 'wcf', array(
				'ACMfeedList' => $this->feedList 
			));
		}
        else {
            return null;
        }
	}
}