<?php
namespace wcf\system\cache\builder;
use \wcf\data\wow\event\WoWEventList;

/**
 * Provides realm status
 * 
 * @author	Veneanar Falkenbann
 * @copyright	2015 Sylvanas Garde
 * @package	com.sylvanasgarde.tools
 * @subpackage	system.BNET
 * @category	Guild Tools
 */

class WoWNextEventsCacheBuilder extends AbstractCacheBuilder {
	/**
     * @see		\wcf\system\cache\builder\AbstractCacheBuilder::$maxLifetime
     */
	protected $maxLifetime = 120;
	
	/**
     * @see		\wcf\system\cache\builder\AbstractCacheBuilder::rebuild()
     */
	protected function rebuild(array $parameters) {
        $WoWCharList = new WoWEventList();
        $WoWCharList->getConditionBuilder()->add('(promo = 1 AND time > UNIX_TIMESTAMP(NOW())) OR time > UNIX_TIMESTAMP(NOW())');
        $WoWCharList->sqlOrderBy ='time ASC';
        $WoWCharList->sqlLimit = @$parameters['eventCount'] ?: 4;
        $WoWCharList->readObjects();
		return $WoWCharList->getObjects();
	}
}
