<?php
namespace wcf\system\cache\builder;
use \wcf\data\wow\feed\WoWFeedACMList;

/**
 * Provides realm status
 * 
 * @author	Veneanar Falkenbann
 * @copyright	2015 Sylvanas Garde
 * @package	com.sylvanasgarde.tools
 * @subpackage	system.BNET
 * @category	Guild Tools
 */

class WoWFeedACMCacheBuilder extends AbstractCacheBuilder {
	/**
     * @see		\wcf\system\cache\builder\AbstractCacheBuilder::$maxLifetime
     */
	protected $maxLifetime = 120;
	
	/**
     * @see		\wcf\system\cache\builder\AbstractCacheBuilder::rebuild()
     */
	protected function rebuild(array $parameters) {
        $WoWFeedList = new WoWFeedACMList();
        $WoWFeedList->sqlOrderBy ='time DESC';
        $WoWFeedList->sqlLimit = @$parameters['feedCount'] ?: 10;
        $WoWFeedList->readObjects();
		return $WoWFeedList->getObjects();
	}
}
