<?php
namespace wcf\system\cache\builder;
use \wcf\data\wow\event\WoWEvent;
use \wcf\data\wow\character\WoWCharacter;



/**
 * Provides realm status
 * 
 * @author	Veneanar Falkenbann
 * @copyright	2015 Sylvanas Garde
 * @package	com.sylvanasgarde.tools
 * @subpackage	system.BNET
 * @category	Guild Tools
 */

class WoWCalendarEventCacheBuilder extends AbstractCacheBuilder {
    /**
     * @see		\wcf\system\cache\builder\AbstractCacheBuilder::$maxLifetime
     */
	protected $maxLifetime = 30;
	
	/**
     * @see		\wcf\system\cache\builder\AbstractCacheBuilder::rebuild()
     */
    function rebuild() {
        $group = null;
        $WoWEvent = new WoWEvent($this->getObjectIDs()[0]);
        $attendees = array();
        if ($WoWEvent->eventGroup->groupID > 0) {
            $group = array(
                'check' => 'ja',
                'groupID' => $WoWEvent->eventGroup->groupID,
                'name' => $WoWEvent->eventGroup->name,
                'wcfGroupID' => $WoWEvent->eventGroup->wcfGroupID,
                'countAttend' => $WoWEvent->eventGroup->countAttend,
            );
        }
        else {
            $group = array(
                'groupID' => 0,
                'name' => '',
                'wcfGroupID' => 0,
                'countAttend' => 0,
            );
        }

        foreach ($WoWEvent->eventAttendees as $attender) {
            $attendees[] = array(
                'char' => new WoWCharacter($attender->charID),
                'state' => $attender->state,
                'attended' => $attender->attended,
                'attendID' => $attender->attendID
                );
        }
        //setlocale(LC_TIME, "de_DE.utf8", "German_Germany.1252", 'de_DE@euro', 'de_DE', 'deu_deu');
        $eventDateTime = new \DateTime('', new \DateTimeZone('UTC'));
        $eventDateTime->setTimestamp($WoWEvent->time);
        $return = array(
            'comment' => $WoWEvent->comment,
            'datetime'=> $eventDateTime->getTimestamp(),
            'description'=> $WoWEvent->description,
            'canEdit'=> true,
            'icon'=> $WoWEvent->icon,
            'link'=> $WoWEvent->link,
            'name'=> $WoWEvent->name,
            'state'=> $WoWEvent->state,    
            'attendees' => $attendees,
            'group' => $group,
            'eventID' => $WoWEvent->eventID
            );
        return $return;
    }
}
