<?php
namespace wcf\data\wow\event;
use wcf\data\DatabaseObject;
use wcf\data\wow\group\WoWGroup;
use wcf\system\WCF;

/**
 * Represents a WoW Event.
 * 
 * @author	Veneanar Falkenbann
 * @copyright	2015 Sylvanas Garde
 * @package	com.sylvanasgarde.tools
 * @subpackage	system.BNET
 * @category	Guild Tools
 * 
 * @property int    $eventID PRIMARY KEY
 * @property string $name name of the event
 * @property int    $groupID Id of teh WoW group assigned to this event
 * @property string $description event description
 * @property int    $time timestamp
 * @property string $icon icon url
 * @property string $comment event comment (only visible after clsing)
 * @property string $link URL to the Events website
 * @property int    $link status of the event 0: deletd, 1: active, 2: locked 3: over, 4:archive
 * @property int    $promo  
 * 
 * Event states:
 * 0 = deleted
 * 1 = active 
 * 2 = locked
 * 3 = over
 * 4 = archive
 */
class WoWEvent extends DatabaseObject {
    /**
     * @see wcf\data\DatabaseObject::$databaseTableName
     */
    protected static $databaseTableName = 'guildtool_events';
    /**
     * @see wcf\data\DatabaseObject::$databaseTableIndexName
     */
    protected static $databaseTableIndexName = 'eventID';

    public $eventAttendees = null;

    /**
     * $eventGroup
     * @see wcf\data\wow\group\WoWGroup
     */
    public $eventGroup = null;

    public $startTime = null;

    public $startDate = null;

    public function __construct($id, array $row = null, DatabaseObject $object = null) {
        parent::__construct($id, $row, $object);
        if ($this->eventID > 0) {
            $attendeeDbList = new WoWEventAttendList();
            $this->eventAttendees = $attendeeDbList->getByEventID($this->eventID, 100);
            $this->eventGroup = new WoWGroup(intval($this->groupID));
            setlocale(LC_TIME, "de_DE.utf8", "German_Germany.1252", 'de_DE@euro', 'de_DE', 'deu_deu');
            $eventDateTime = new \DateTime();
            $eventDateTime->setTimestamp($this->time);
            $this->startTime = $eventDateTime->format('H:i');
            $this->startDate = strftime('%A, der %d.%m.', $eventDateTime->getTimestamp());
        }
    }


}