<?php
namespace wcf\system\wow;
use wcf\util\HTTPTools;
use wcf\system\exception\SystemException;
use wcf\system\WCF;
use wcf\util\StringUtil;

/**
 * The BnetSite class handles all non-API bnet operations.
 * 
 * 
 * @author	Veneanar
 * @copyright	2015 Sylvanas Garde
 * @package	com.sylvanasgarde.guildtool
 * @category	Guild Tool
 */
class BNETSite extends HTTPTools {

	/**
     * content
     * @var	string
     */
	protected $content = '';

	/**
     * url
     * @var	string
     */
	public $url = '';
	

	/**
     * Opens a battle.net site.
     * 
     * @param	string		$url
     * @param	string		$login
     * @param	array		$options
     */
	public function __construct($url, $login = false, $options = array()) {
		$this->url = $url;
        if ($login && !$this->openURL()) {
            if (empty($options) || empty($options['username']) || empty($options['password'])) {
                throw new SystemException('Battle.net Login Credentials missing');
            }
			$this->login($options['username'],$options['password']);
		}
        if (!$this->openURL(true)) {
            throw new SystemException('Can not retrive battle.net site '.$this->url.' is protected. Require login!');
        }
	}
	
	/**
     * Crawl the login for a valid token
     * Do not call this function directly.
     * 
     * @return	string
     */
    private function getToken() {
        $result = self::open('https://'.GUILDTOOL_BNET_HOST.'/login/en-us/index');
        if ($result['status']!=200) {
            throw new SystemException('Can not get battle.net security token via '. 'https://'.GUILDTOOL_BNET_HOST.'/login/en-us/index');
        }
        $token = array();
        preg_match( '/name="csrftoken" value="([^"]*)"/i', $result['content'], $token ) ;
        $sess = array();
        preg_match( '/name="sessionTimeout" value="([^"]*)"/i', $result['content'], $sess ) ;

        return array(
         'token' => $token[1],
         'session' => $sess[1]
         );
    }


    /**
     * Call the battle.net site
     * Do not call this function directly.
     * @param boolean $override
     * @return	boolean
     */
    protected function openURL($override = false) {
        $response = self::open($this->url);
        if($response['status'] !=200) {
            throw new SystemException('Can not retrive battle.net site '.$this->url.' returns a ' . $response['status']);
        } 
        if (!$override) {
            if (strpos(($response['content']),'Location: https://'.GUILDTOOL_BNET_HOST.'/login/?ref=') > 0 || strpos(($response['content']),'"type": "LOGIN_FORM"') > 0 ) {
                return false;
            }
        }
        $this->content = $response['content'];
        return true;
    }

    /**
     * login to battle.net
     * Do not call this function directly.
     * 
     * @param	string		$username
     * @param	string		$password
     */
    private function login($username, $password) {
        $sec = self::GetToken();
        $options = array(
            CURLOPT_POST => 1,
            CURLOPT_HEADER => true, 
		    CURLOPT_POSTFIELDS => http_build_query(array(
                'accountName' => $username,
		        'password' => $password,
		        'persistLogin' => 'on',
		        'csrftoken' => $sec['token'],
                'sessionTimeout' => $sec['session']
            )),
        );
        $response = self::open('https://'.GUILDTOOL_BNET_HOST.'/login/en-us/index', $options);
        if($response['status'] != 200) {
            $response['content'];
            throw new SystemException('Can not login to battle.net ' . $response['status']);
        }
        if (strpos($response['content'],'The username or password is incorrect') > 0) {
            throw new SystemException('Can not login to battle.net: credentials wrong');
        }
    }

    /**
     * Returns the content of the crawled site
     * use for testing purposes only
     * 
     * @return	string
     */
    public function getSite() {
        return $this->content;
    }
}