<?php
namespace wcf\system\dashboard\box;
use \wcf\data\dashboard\box\DashboardBox;
use \wcf\page\IPage;
use \wcf\system\cache\builder\WoWTokenInfoCacheBuilder;
use wcf\system\exception\SystemException;

use \wcf\system\WCF;

/**
 * Dashboardbox for the Tokenprice.
 * 
 * @author	    Veneanar
 * @copyright	2015 Sylvanas Garde
 * @package	    com.sylvanasgarde.guildtool
 * @category	Guild Tool
 */
class WoWTokenSidebarDashboardBox extends AbstractSidebarDashboardBox {
	/**
     * Tokendata
     * @see		\wcf\data\wow\WoWToken
     */
	protected $tokendata = null;
	
	/**
     * @see		\wcf\system\dashboard\box\IDashboardBox::init()
     */
	public function init(DashboardBox $box, IPage $page) {
		parent::init($box, $page);
		$this->tokendata =  WoWTokenInfoCacheBuilder::getInstance()->getData();
		$this->fetched();
	}
	
	/**
     * @see		\wcf\system\dashboard\box\AbstractContentDashboardBox::render()
     */
	protected function render() {
		if (!empty($this->tokendata)) {
			return WCF::getTPL()->fetch('dashboardBoxWoWTokenSidebar', 'wcf', array(
				'token' => $this->tokendata[0]
			));
		}
        else {
            throw new SystemException('no token data');
        }
	}
}
