<?php
namespace wcf\system\cronjob;
use wcf\system\wow\BNETAPI;
use wcf\data\cronjob\Cronjob;
use wcf\data\wow\WoWToken;
use wcf\system\wow\WoWTokenInfo;

/**
 * Updates the WoW Token Price.
 * 
 * Should run every 15 min.
 * 
 * @author	Veneanar Falkenbann
 * @copyright	2015 Sylvanas Garde
 * @package	com.sylvanasgarde.tools
 * @subpackage	system.BNET
 * @category	Guild Tools

 */
class WoWTokenCronjob extends AbstractCronjob {
    private static function doaction() {
        WoWToken::create(WoWTokenInfo::getToken());
    }
    /**
     * @see wcf\system\cronjob\ICronjob::execute()
     */
    public function execute(Cronjob $cronjob) {
        parent::execute($cronjob);
        if (GUILDTOOL_BNET_API_ACTIVE) static::doaction();
    }
    public static function directexecute() {
        if (GUILDTOOL_BNET_API_ACTIVE)  static::doaction();
    }   
}
