<?php
namespace wcf\data\wow\event;
use wcf\data\DatabaseObjectEditor;
use wcf\data\user\group\UserGroup;
use wcf\data\wow\group\WoWGroupList;
use wcf\data\wow\group\WoWGroup;
use wcf\data\wow\character\WoWCharacter;
use wcf\data\wow\character\WoWCharacterEditor;
use wcf\system\wow\BNETAPI;
use wcf\util\StringUtil;
use wcf\system\WCF;

/**
 * Provides functions to edit a WoW Event.
 * 
 * @author	Veneanar Falkenbann
 * @copyright	2015 Sylvanas Garde
 * @package	com.sylvanasgarde.tools
 * @subpackage	system.BNET
 * @category	Guild Tools
 */
class WoWEventEditor extends DatabaseObjectEditor {
    /**
     * @see wcf\data\DatabaseObjectDecorator::$baseClass
     */
    protected static $baseClass = 'wcf\data\wow\event\WoWEvent';
    /**
     * Prepare and update attendeelist. 
     * 
     * @param array $bnetdata
     */
    private static function updateAttendees($eventID, $bnetdata, $close = false) {
        $attenddata = array();
        foreach ($bnetdata as $attend) {
            $realm = BNETAPI::getHomeRealm($attend['name'], true);
            if ($realm['status']) {
                $wowc = WoWCharacter::GetByName($attend['name'], $realm['data']);
                if (intval($wowc->getObjectID())==0) {
                    $bnetval = BNETAPI::getCharacterDetails($attend['name'], $realm['data'], array('guild'));
                    if ($bnetval['status']) $wowc = WoWCharacterEditor::createFromBNET($bnetval['data']);
                }
                if ($close) {
                    $attenddata[] = array(
                                        'charID'=> intval($wowc->getObjectID()),
                                        'attended'=> intval($attend['attended'])
                                        );   
                } 
                else { 
                    $attenddata[] = array(
                                        'charID'=> intval($wowc->getObjectID()),
                                        'state'=> intval($attend['state'])
                                        );
                }
            }
        }
        if ($close) {
            WoWEventAttendEditor::updateAttendeeAttandence(intval($eventID), $attenddata);
        } 
        else {
            WoWEventAttendEditor::upsertAttendeeState(intval($eventID), $attenddata);
        }

    }

    /**
     * Create a Event from Arsenal. 
     * Param $bnetdata see 
     * returns a new WoWEvent object
     * see wcf\sgt\bnet\WoWEvent
     * 
     * @param array $bnetdata
     * @return object
     */
    public static function createFromBNET($bnetdata) {
        // searchCalenadarQuerry
        $sql = "SELECT		groupID
				FROM		wcf".WCF_N."_guildtool_guildgroups
                WHERE       searchCalenadarQuerry LIKE ?
				";
        $statement = WCF::getDB()->prepareStatement($sql);
        $statement->execute( array(StringUtil::trim($bnetdata['name'])));
		$row = $statement->fetchArray();
        $groupID = ($row['groupID']) ?: 0;
        $url = 'https://sylvanasgarde.com';
        if ($groupID > 0) {
            $group = new WoWGroup($groupID);
            $url = $group->groupURL;
        }

        $insert = array(
					'eventID' => intval($bnetdata['ID']),
					'name' => $bnetdata['name'], 
					'description' => $bnetdata['description'], 
					'time' => $bnetdata['datetime'],  
					'icon' => $bnetdata['icon'],  
                    'groupID' => $groupID,
                    'link' => $url
            );
        if (!empty($bnetdata['attendees'])) {
            self::updateAttendees(intval($bnetdata['ID']), $bnetdata['attendees']);
        }
        return parent::create($insert);
    }

    /**
     * Updates an Event from Arsenal. 
     * Param $bnetdata see 
     *
     * see wcf\sgt\bnet\WoWEvent
     * 
     * @param array $bnetdata
     */
    public function updateFromBNET($bnetdata) {
        // check if event is not deleted (state=0) and not archivied (4 or higher) and current time > event start time 
        $t_time = new \DateTime('now');
        $state = $this->state;
        if (($this->state > 0) && ($this->state  < 4) && ($t_time->getTimestamp() > $bnetdata['datetime']) ) {
            // set state to 3 
            $state = 3;
        }
        $update = array(
					'eventID' => intval($bnetdata['ID']),
					'name' => $bnetdata['name'], 
					'description' => $bnetdata['description'], 
					'time' => $bnetdata['datetime'],  
					'icon' => $bnetdata['icon'],  
                    'comment' => $t_time->format('Y-m-d H:i:s'),
                    'state' => $state

            );
        if (!empty($bnetdata['attendees'])) {
            self::updateAttendees(intval($this->getObjectID()), $bnetdata['attendees']);
        }
        parent::update($update);
    }


    public function preparecloseEvent($comment, $attendees = array()) {
        $update = array(
               'comment'=>$comment,
               );
        if (!empty($attendees)) {
            self::updateAttendees(intval($this->getObjectID()), $attendees, true);
        }
        parent::update($update);
        
    }
}
