<?php
namespace wcf\data\wow\event;
use wcf\data\DatabaseObjectList;

/**
 * Represents a list a WoW Event attendese.
 * 
 * @author	Veneanar Falkenbann
 * @copyright	2015 Sylvanas Garde
 * @package	com.sylvanasgarde.tools
 * @subpackage	system.BNET
 * @category	Guild Tools
 */
class WoWEventAttendList extends DatabaseObjectList {
    /**
     * @see wcf\data\DatabaseObjectList::$className
     */
    public $className = 'wcf\data\wow\event\WoWEventAttend';

    public function getByEventID($eventID, $maxResult = 50) {
        $this->sqlLimit = $maxResult;
        $this->getConditionBuilder()->add("eventID = ?", array($eventID));
        $this->readObjects();
        return $this->getObjects();
    }

}