<?php
namespace wcf\data\wow\character;
use wcf\data\DatabaseObjectList;
use wcf\system\WCF;
/**
 * Represents a list a WoW Characters.
 * 
 * @author	Veneanar Falkenbann
 * @copyright	2015 Sylvanas Garde
 * @package	com.sylvanasgarde.tools
 * @subpackage	system.BNET
 * @category	Guild Tools
 */
class WoWCharacterList extends DatabaseObjectList {
    /**
     * @see wcf\data\DatabaseObjectList::$className
     */
    private $counter = null;

    public $className = 'wcf\data\wow\character\WoWCharacter';

    public function __construct() {
        parent::__construct();
        $this->getConditionBuilder()->add('state > 0');
    }
    private function getTotalRows() {
        $sql = "SELECT	COUNT(*) AS count
			FROM	".$this->getDatabaseTableName()." ".$this->getDatabaseTableAlias();
		$statement = WCF::getDB()->prepareStatement($sql);
		$statement->execute($this->getConditionBuilder()->getParameters());
		$row = $statement->fetchArray();
        $this->counter = intval($row['count']);
		return $this->counter;
    }

    public function countAll() {
        return $this->counter ?: $this->getTotalRows();
    }
}
