<?php
namespace wcf\data\wow\character;
use wcf\data\DatabaseObject;
use wcf\data\user\group\UserGroup;
use wcf\data\user\User;
use wcf\system\WCF;
use wcf\data\wow\group\WoWGroup;
/**
 * Represents a WoW Character.
 * 
 * @author	Veneanar Falkenbann
 * @copyright	2015 Sylvanas Garde
 * @package	com.sylvanasgarde.tools
 * @category	Guild Tools
 * 
 * @property int    $charID     PRIMARY KEY
 * @property string $charname   Charactername
 * @property string $realmname  Realmname
 * @property int    $class      class
 * @property int    $race       race
 * @property int    $gender     gender
 * @property int    $level      level
 * @property string $avatar     avatar URL
 * @property int    $userID     ID of the wcf User
 * @property int    $inGuild    is in guild 
 * @property int    $primaryRole primary role 
 * @property int    $secondaryRole secondary role
 * @property int    $isMain     is main char
 * @property string $guildGroup in which guil groups is the char
 * @property int    $rank       guildrank 
 * @property int    $achievementPoints ACM points
 * @property int    $state      steus
 * 
 * 
 */

class WoWCharacter extends DatabaseObject {
    /**
     * @see wcf\data\DatabaseObject::$databaseTableName
     */
    protected static $databaseTableName = 'guildtool_playerdata';
    /**
     * @see wcf\data\DatabaseObject::$databaseTableIndexName
     */
    protected static $databaseTableIndexName = 'charID';

    /**
     * $groupList
     * WoWGroup of the char
     * @var	array
     * @see \wcf\data\wow\group\WoWGroup
     */
    public $groupList = null;

    /**
     * $user
     * WCF User of the char
     * @var	\wcf\data\user\User
     */
    public $user = null;

    /**
     * $rankname
     * localized rankname
     * @var	string
     * see WCF option: GUILDTOOL_GUILD_RANKS
     */
    public $rankname = '';

    /**
     * $arsenallink
     * localized arsenallink
     * @var	string
     * see WCF option: GUILDTOOL_BNET_HOST & GUILDTOOL_BNET_LANGUAGE
     */
    public $arsenallink = '';

	/**
     * get the ranknames
     * 
     * @return	array Array of Guildranks
     */
    private static function getRankList() {
        return array_map('trim', explode(',', GUILDTOOL_GUILD_RANKS));
    }

	/**
     * Creates a new instance of the WoWCharackter class.
     * 
     * @param	mixed				$id
     * @param	array				$row
     * @param	\wcf\data\DatabaseObject		$object
     */
    public function __construct($id, array $row = null, DatabaseObject $object = null) {
        parent::__construct($id, $row, $object);
        if (intval($this->charID) > 0) {
            if (intval($this->userID) != 0) $this->user = new User($this->userID);
            $this->groupList = $this->getGroups();
            $guildranknames  = static::getRankList();
            if (intval($this->rank) >= count($guildranknames)) {
                $this->rankname = $this->rank;
            } else {
                $this->rankname = $guildranknames[intval($this->rank)];
            }
            $this->arsenallink = 'http://'.GUILDTOOL_BNET_HOST.'/wow/'.GUILDTOOL_BNET_LANGUAGE.'/character/'.$this->realmname.'/'.$this->charname.'/simple';
        }
    }
	/**
     * get WoWCharacter by Charname & Realmname
     * 
     * @param $charname string Charactername
     * @param $realmname string Realmname
     * @return	\wcf\data\wow\character\WoWCharacter
     */
    public static function GetByName($charname, $realmname) {
        $sql = "SELECT * 
               FROM wcf".WCF_N."_guildtool_playerdata
               WHERE charname LIKE ? 
               AND realmname LIKE ?";
		$statement = WCF::getDB()->prepareStatement($sql);
		$statement->execute(array($charname, $realmname));
		$row = $statement->fetchArray();
		if (!$row) $row = array();
        return new WoWCharacter(null, $row);
    }

	/**
     * get WoWCharacter by Charname & Realmname
     * 
     * @return	array of WoWGroup
     * @see \wcf\data\wow\group\WoWGroup
     */
    private function getGroups() {
        $groupList = array();
        $groupIDList = empty($this->guildGroup) ? array() : unserialize($this->guildGroup);
        foreach($groupIDList as $groupID) {
            $groupList[] = new WoWGroup($groupID);
        }
        return $groupList;
    }


}
