<?php
namespace wcf\system\wow;
use wcf\util\HTTPTools;
use wcf\system\exception\SystemException;
use wcf\system\WCF;
use wcf\util\StringUtil;
/**
 * The WCL API class handles all needed API Warcraftlogs operations.
 * 
 * @author	Veneanar
 * @copyright	2015 Sylvanas Garde
 * @package	com.sylvanasgarde.guildtool
 * @category	Guild Tool
 */
class WCLAPI extends HTTPTools {
    
    /**
     * recieve a list of logs from a give date
     * return 
     * 
     * @param	\DateTime		$date Startdate
     * @param	\DateTime		$date Enddate (optional default +24h)
     * @return	array		
     */
    public static function getReportList($startdate, $enddate = null) {
        $start_timestamp = $startdate->getTimestamp() * 1000;
        $end_timestamp = $enddate==null ? $startdate->add(new \DateInterval('P1D'))->getTimestamp() * 1000 : $enddate->getTimestamp() * 1000;
        $uri = 'https://www.warcraftlogs.com:443/v1/reports/guild/'. rawurlencode(GUILDTOOL_GUILD_NAME) .'/'. rawurlencode(GUILDTOOL_GUILD_HOMEREALM) . '/'. GUILDTOOL_BNET_API_REGION .'/?start='.$start_timestamp . '&end='. $end_timestamp .'&api_key='.GUILDTOOL_WCL_API_KEY;   
        return json_decode(static::open($uri)['content'], true);
    }

    public static function getReport($reportID) {
        $uri = 'https://www.warcraftlogs.com:443/v1/report/fights/'.$reportID.'?api_key='.GUILDTOOL_WCL_API_KEY;
        return json_decode(static::open($uri)['content'], true);
    }

    public static function convertReportToAttend($reportID = null, $report = array()) {
        $report = $reportID==null ? $report : static::getReport($reportID);
        $returnarray = array();
        foreach ($report['friendlies'] as $attender) {
            if ($attender['type']!='NPC') {
                $returnarray[] = array(
                   'name' => $attender['name'],
                   'attended' => 1
                   );
            }
        }
        return $returnarray;
    }
}