<?php
namespace wcf\system\cronjob;
use wcf\system\wow\BNETAPI;
use wcf\data\cronjob\Cronjob;
use wcf\data\wow\feed\WoWFeedACM;
use wcf\system\exception\SystemException;
/**
 * Updates the Char Events table.
 * 
 * Should run every 15 min.
 * 
 * @author	Veneanar Falkenbann
 * @copyright	2015 Sylvanas Garde
 * @package	com.sylvanasgarde.tools
 * @subpackage	system.BNET
 * @category	Guild Tools

 */
class WoWFeedACMCronjob extends AbstractCronjob {
    private static function doaction() {
        $bnetFeed= BNETAPI::getGuildFeed('playerAchievement');
        if (!$bnetFeed['status']) throw new SystemException('b.net down');
        foreach ($bnetFeed['data'] as $bnetnews) {
            WoWFeedACM::create($bnetnews);
        }   
    }
    /**
     * @see wcf\system\cronjob\ICronjob::execute()
     */
    public function execute(Cronjob $cronjob) {
        parent::execute($cronjob);
        if (GUILDTOOL_BNET_API_ACTIVE) static::doaction();
    }
    public static function directexecute() {
        if (GUILDTOOL_BNET_API_ACTIVE)  static::doaction();
    }   
}
