<?php
namespace wcf\system\cronjob;
use wcf\system\wow\BNETCalendar;
use wcf\data\cronjob\Cronjob;
use wcf\data\wow\event\WoWEvent;
use wcf\data\wow\event\WoWEventEditor;

/**
 * Updates the calendar Events table.
 * 
 * Should run every 15 min.
 * 
 * @author	Veneanar Falkenbann
 * @copyright	2015 Sylvanas Garde
 * @package	com.sylvanasgarde.tools
 * @subpackage	system.BNET
 * @category	Guild Tools

 */
class CalendarDataCronJob extends AbstractCronjob{
    private static function doaction() {
        $bnetclaendar = new BNETCalendar(GUILDTOOL_BNET_EMAIL, GUILDTOOL_BNET_PWD, GUILDTOOL_BNET_CHAR);
        $eventListBNET = $bnetclaendar->getEventList();
        foreach ($eventListBNET as $eventBNET) {
            $event = $bnetclaendar->getEventDetails($eventBNET);
            $wowevent = new WoWEvent($event['ID']);
            if ($wowevent->getObjectID()==0) {
                WoWEventEditor::createFromBNET($event);
            }
            else {
                $wowEventEdit = new WoWEventEditor($wowevent);
                $wowEventEdit->updateFromBNET($event);
            } 
        }
        
    }
    /**
     * @see wcf\system\cronjob\ICronjob::execute()
     */
    public function execute(Cronjob $cronjob) {
        parent::execute($cronjob);
        if (GUILDTOOL_BNET_ACTIVE) static::doaction();
    }
    public static function directexecute() {
        if (GUILDTOOL_BNET_ACTIVE) static::doaction();
    }

}
