<?php
namespace wcf\page;
use wcf\system\WCF;
use wcf\system\menu\page\PageMenu;
use wcf\data\wow\group\WoWGroupList;
use wcf\data\wow\group\WoWGroup;
use wcf\data\wow\character\WoWCharacterList;
use wcf\data\user\User;
use wcf\data\wow\event\WoWEventCalendar;


/**
 * Shows the Group details
 * 
 * 
 * @author	Veneanar Falkenbann
 * @copyright	2015 Sylvanas Garde
 * @package	com.sylvanasgarde.tools
 * @subpackage	system.BNET
 * @category	Guild Tools

 */

class GuildRoasterPage extends AbstractPage {
    /**
     * @see wcf\page\AbstractPage::$activeMenuItem
     */

    const RESULT_PER_PAGE = 30;

    public $activeMenuItem = 'wcf.page.GuildTool.GuildRoaster';

	public $enableTracking = true;
	
	public $templateName = 'guildRoaster';

    private $sortField = 'rank';

    private $sortOrder = 'ASC';

    private $pageNo = 1;


    public function readParameters() {
        parent::readParameters();
        if (isset($_REQUEST['sortField'])) $this->sortField = $_REQUEST['sortField'];
        if (isset($_REQUEST['sortOrder'])) $this->sortOrder = $_REQUEST['sortOrder'];
        if (isset($_REQUEST['pageNo'])) $this->pageNo = $_REQUEST['pageNo'];

    }
	/**
     * @see Page::assignVariables()
     */
	public function assignVariables() {
		parent::assignVariables();
        $WoWGroups = new WoWGroupList();
        $WoWGroups->readObjects();
        $WoWChars = new WoWCharacterList();
        $WoWChars->sqlOffset=($this->pageNo-1) * static::RESULT_PER_PAGE;
        $WoWChars->sqlLimit=static::RESULT_PER_PAGE;
        $WoWChars->sqlOrderBy = $this->sortField .' '. $this->sortOrder;
        $WoWChars->readObjects();
        $cvar = ceil($WoWChars->countAll() / static::RESULT_PER_PAGE);
        $eventCalendar = new WoWEventCalendar(); 
		WCF::getTPL()->assign(array(
            'sortField' => $this->sortField,
            'pageNo' => $this->pageNo,
            'sortOrder' => $this->sortOrder,
            'WoWGroups' => $WoWGroups->getObjects(),
			'WoWChars' => $WoWChars->getObjects(),
            'pageCount' => $cvar, 
            'eventCalendar' => $eventCalendar->getCalendar()
            ));
    }

    
    /**
     * @see Page::show()
     */
	public function show() {
        //mark Page as active
		PageMenu::getInstance()->setActiveMenuItem($this->activeMenuItem);
		parent::show();
	}

}
