<?php
namespace wcf\data\wow\group;
use wcf\data\DatabaseObject;
use wcf\data\user\group\UserGroup;
use wcf\data\user\User;
use wcf\system\WCF;
/**
 * Represents a WoW Character.
 * 
 * @author	Veneanar Falkenbann
 * @copyright	2015 Sylvanas Garde
 * @package	com.sylvanasgarde.tools
 * @subpackage	system.BNET
 * @category	Guild Tools
 * 
 * @property int    $groupID PRIMARY KEY
 * @property int    $wcfGroupID assigned WCF Group
 * @property string $name group Name
 * @property string $groupURL URl of the groups website
 * @property string $searchCalenadarQuerry string to identify the calendar event
 * @property int    $renderEventsPup show events to all users?
 * @property int    $showRoasterPup publish roaster to all users?
 * @property string $renderEventsForum render Evnts in Forumids
 * @property string $showRoasterForum render Roaster in Forums (ID) 
 * @property string $groupShortDesc short description no HTML! 
 * @property string $groupLongDesc long description HTML allowed 
 * @property string $groupPicture URl to image 
 * @property int    $publish publish events?
 * @property int    $publishFeed publsih to feed?
 * @property int    $countAttend count attendenca? 
 * @property string $pointarray a serialized array for points transactioncalc 

 *  
 */
class WoWGroup extends DatabaseObject {
    /**
     * @see wcf\data\DatabaseObject::$databaseTableName
     */
    protected static $databaseTableName = 'guildtool_guildgroups';
    /**
     * @see wcf\data\DatabaseObject::$databaseTableIndexName
     */
    protected static $databaseTableIndexName = 'groupID';

    public $WCFGroup = null; 
    
    public function __construct($id, array $row = null, DatabaseObject $object = null) {
        parent::__construct($id, $row, $object);
        $this->WCFGroup = new UserGroup($this->WCFGroupID);
    }

}
