<?php
namespace wcf\system\dashboard\box;
use \wcf\data\dashboard\box\DashboardBox;
use \wcf\page\IPage;
use \wcf\system\cache\builder\WoWNewMemberCacheBuilder;
use wcf\system\exception\SystemException;

use \wcf\system\WCF;

/**
 * Dashboardbox for the Achievment Feeds.
 * 
 * @author	    Veneanar
 * @copyright	2015 Sylvanas Garde
 * @package	    com.sylvanasgarde.guildtool
 * @category	Guild Tool
 */
class WoWNewMemberSidebarDashboardBox extends AbstractSidebarDashboardBox {
	/**
     * realms
     * @var		array
     */
	protected $member = null;
	
	/**
     * @see		\wcf\system\dashboard\box\IDashboardBox::init()
     */
	public function init(DashboardBox $box, IPage $page) {
		parent::init($box, $page);
		$this->member =  WoWNewMemberCacheBuilder::getInstance()->getData();
        $this->fetched();
	}
	
	/**
     * @see		\wcf\system\dashboard\box\AbstractContentDashboardBox::render()
     */
	protected function render() {
		if (!empty($this->member)) {
			return WCF::getTPL()->fetch('dashboardBoxWoWLatestMember', 'wcf', array(
				'charList' => $this->member
			));
		}
        else {
            throw new SystemException('no member data');
        }
	}
}

