<?php
namespace wcf\system\cronjob;
use wcf\system\wow\BNETAPI;
use wcf\data\cronjob\Cronjob;
use wcf\data\wow\character\WoWCharacter;
use wcf\data\wow\character\WoWCharacterEditor;
use wcf\system\exception\SystemException;
/**
 * Updates the Char Events table.
 * 
 * Should run every 15 min.
 * 
 * @author	Veneanar Falkenbann
 * @copyright	2015 Sylvanas Garde
 * @package	com.sylvanasgarde.tools
 * @subpackage	system.BNET
 * @category	Guild Tools

 */
class CharDataCronJob extends AbstractCronjob {
    private static function doaction() {
        $bnetGuilRoaster = BNETAPI::getGuildRoster();
        if (!$bnetGuilRoaster['status']) throw new SystemException('b.net down');
        foreach ($bnetGuilRoaster['data']['members'] as $bnetMember) {
            $wowc = WoWCharacter::GetByName($bnetMember['character']['name'], $bnetMember['character']['realm']);
            if (intval($wowc->getObjectID())==0) {
                //echo "Lege neuen Char an: " . $bnetMember['character']['name'] . "(". $bnetMember['character']['realm']. ")";
                $wowc = WoWCharacterEditor::createFromBNET($bnetMember['character']);
            }
            else {
                //echo "Update Char ID" . $wowc->getObjectID() .": " . $bnetMember['character']['name'] . "(". $bnetMember['character']['realm']. ")";
                $charEditor = new WoWCharacterEditor($wowc);
                $charEditor->updateFromBNET($bnetMember['character']);
            }
        }   
    }
    /**
     * @see wcf\system\cronjob\ICronjob::execute()
     */
    public function execute(Cronjob $cronjob) {
        parent::execute($cronjob);
        if (GUILDTOOL_BNET_API_ACTIVE) static::doaction();
    }
    public static function directexecute() {
        if (GUILDTOOL_BNET_API_ACTIVE)  static::doaction();
    }   
}
