<?php
namespace wcf\data\wow\event;
use wcf\data\DatabaseObjectEditor;
use wcf\data\user\group\UserGroup;
use wcf\system\WCF;

/**
 * Provides functions to edit a Event attend.
 * 
 * @author	Veneanar Falkenbann
 * @copyright	2015 Sylvanas Garde
 * @package	com.sylvanasgarde.tools
 * @subpackage	system.BNET
 * @category	Guild Tools
 */
class WoWEventAttendEditor extends DatabaseObjectEditor {
    /**
     * @see wcf\data\DatabaseObjectDecorator::$baseClass
     */
    protected static $baseClass = 'wcf\data\wow\event\WoWEventAttend';
    /**
     * internal static update 
     * 
     * @param integer ID of the Attender
     * @param array sql update
     */
    private static function staticupdate($id, array $parameters = array()) {
		if (empty($parameters)) return;
		
		$updateSQL = '';
		$statementParameters = array();
		foreach ($parameters as $key => $value) {
			if (!empty($updateSQL)) $updateSQL .= ', ';
			$updateSQL .= $key . ' = ?';
			$statementParameters[] = $value;
		}
		$statementParameters[] = $id;
		
		$sql = "UPDATE	".static::getDatabaseTableName()."
			SET	".$updateSQL."
			WHERE	".static::getDatabaseTableIndexName()." = ?";
		$statement = WCF::getDB()->prepareStatement($sql);
		$statement->execute($statementParameters);

    }

    /**
     * updates attendees of an given event 
     * 
     * @param integer ID of the event
     * @param array attendee list (charID, sate)
     */
    public static function upsertAttendeeState($eventID, $attendees) {
        $EventAttendList = new WoWEventAttendList();
        $attendListDB = $EventAttendList->getByEventID($eventID, count($attendees)+1);
        foreach ($attendees as $attend) {
            $exists = false;
            foreach ($attendListDB as $attendDB) {
                if (intval($attend['charID'])==intval($attendDB->charID))     {
                    if (intval($attend['state'] != intval($attendDB->data['state']))) {
                        self::staticupdate($attendDB->attendID, array(
                            'state'=> $attend['state']
                            ));
                    }
                    $exists = true;
                    break;
                }
            }
            if (!$exists) {
                static::create(array(
                    'eventID'=> $eventID,
                    'charID'=> intval($attend['charID']),
                    'state'=> intval($attend['state'])  
                ));
            }            
        }
    }

    public static function updateAttendeeAttandence($eventID, $attendees) {
        $EventAttendList = new WoWEventAttendList();
        $attendListDB = $EventAttendList->getByEventID($eventID, count($attendees)+1);
        foreach ($attendees as $attend) {
            foreach ($attendListDB as $attendDB) {
                if (intval($attend['charID'])==intval($attendDB->charID))     {
                    if (intval($attend['attended'] != intval($attendDB->attended))) {
                        self::staticupdate($attendDB->attendID, array(
                            'attended'=> $attend['attended']
                            ));
                    }
                    break;
                }
            }
        }
    }

}
