<?php
namespace wcf\data\wow\event;
use wcf\data\DatabaseObjectEditor;
use wcf\data\AbstractDatabaseObjectAction;
use\wcf\system\WCF;
use\wcf\util\StringUtil;
use wcf\system\exception\UserInputException;
use wcf\system\exception\PermissionDeniedException;
use wcf\system\wow\WCLAPI;



/**
 * Provides functions to edit a WoW Character.
 * 
 * @author	Veneanar Falkenbann
 * @copyright	2015 Sylvanas Garde
 * @package	com.sylvanasgarde.tools
 * @subpackage	system.BNET
 * @category	Guild Tools
 */
class WoWEventAttendAction extends AbstractDatabaseObjectAction {
	/**
     * @see	\wcf\data\AbstractDatabaseObjectAction::$className
     */
	public $className = 'wcf\data\wow\event\WoWEventAttendEditor';
	
	/**
     * @see	\wcf\data\AbstractDatabaseObjectAction::$permissionsUpdate
     */
	protected $permissionsUpdate = array('mod.guildtool.canEditEvent');
    /**
     * @see	\wcf\data\AbstractDatabaseObjectAction::$permissionsDelete
     */
	protected $permissionsDelete = array('admin.guildtool.canDeleteEvent');	
	/**
     * @see	\wcf\data\AbstractDatabaseObjectAction::$requireACP
     */
	protected $requireACP = array('create');

    protected $WoWChar = null;

	/**
     * Validates permissions and parameters.
     */
	public function validateChange() {
        if (empty($this->objects)) {
			$this->readObjects();
			if (empty($this->objects)) {
				throw new UserInputException('attendID');
			}
		}
        foreach ($this->objects as $event) {
			if ($event->state == 0) {
				throw new PermissionDeniedException();
			}
		}
	}

    public function validateSetEnrollment() {
		$this->validateChange();
        if (!isset($this->parameters['setState'])) throw new UserInputException('setState'); 
        parent::validateUpdate();
    }

    public function validateChangeAttended() {
		$this->validateChange();
        if (!isset($this->parameters['attended']) || !is_int($this->parameters['attended'])) throw new UserInputException('attended'); 
        parent::validateUpdate();
    }

    public function validateToggleAttended() {
		$this->validateChange();
        parent::validateUpdate();
    }

    /**
     * change Attendence State
     *  
     */
    public function setEnrollment() {
        $newState = $this->parameters['setState'];        
        $eventAction = new WoWEventAttendAction($this->objectIDs, 'update', array(
                'data' => array(
                    'state' => $newState
                )
            ));
        $eventAction->executeAction();
        return $newState;
    }

    public function toggleAttended() {
        $WoWEventAttend = new WoWEventAttend($this->getObjectIDs()[0]);
        $newState = (intval($WoWEventAttend->attended) == 1) ? 0 : 1;
        $eventAction = new WoWEventAttendAction($this->objectIDs, 'update', array(
                'data' => array(
                    'attended' => $newState
                )
            ));
        $eventAction->executeAction();
        return $newState;
    }

    public function changeAttended() {
        $newState = intval($this->parameters['attended']);
        $eventAction = new WoWEventAttendAction($this->objectIDs, 'update', array(
                'data' => array(
                    'attended' => $newState
                )
            ));
        $eventAction->executeAction();
        return $newState;
    }

}
