<?php
namespace wcf\page;
use wcf\system\WCF;
use wcf\system\menu\page\PageMenu;
use wcf\data\wow\group\WoWGroupList;
use wcf\data\wow\group\WoWGroup;
use wcf\data\wow\character\WoWCharacterList;
use wcf\data\user\User;


/**
 * Shows the Group details
 * 
 * 
 * @author	Veneanar Falkenbann
 * @copyright	2015 Sylvanas Garde
 * @package	com.sylvanasgarde.tools
 * @subpackage	system.BNET
 * @category	Guild Tools

 */

class GuildRoasterPage extends AbstractPage {
    /**
     * @see wcf\page\AbstractPage::$activeMenuItem
     */

    const RESULT_PER_PAGE = 30;

    //public $activeMenuItem = 'wcf.page.GuildTool.GuildRoaster';

	//public $enableTracking = true;
	
	public $templateName = 'guildRoaster';

    private $sortField = 'rank';

    private $sortOrder = 'ASC';

    private $pageNo = 1;


    public function readParameters() {
        parent::readParameters();


    }
	/**
     * @see Page::assignVariables()
     */
	public function assignVariables() {
		parent::assignVariables();
        $date = new \DateTime();
        $week = array();
        for ($i = 0; $i <= 13; $i++) {
            $week[] = array(
                'startTime'=> $date->modify('this week +'.$i),
                'endTime'=> $date->modify('this week +'.$i+1),
                'events' => array(),
                );
        }
	}

    
    /**
     * @see Page::show()
     */
	public function show() {
        // mark Page as active
		//PageMenu::getInstance()->setActiveMenuItem($this->activeMenuItem);
		parent::show();
	}

}
