<?php
namespace wcf\data\wow\feed;
use wcf\system\exception\SystemException;
use wcf\data\DatabaseObject;
use wcf\system\WCF;
use wcf\data\wow\character\WoWCharacter;
use wcf\data\wow\character\WoWCharacterEditor;
use wcf\system\wow\BNETAPI;
/**
 * Represents a WoW Achievment Feed .
 * 
 * @author	Veneanar Falkenbann
 * @copyright	2015 Sylvanas Garde
 * @package	com.sylvanasgarde.tools
 * @subpackage	system.BNET
 * @category	Guild Tools
 */

class WoWFeedACM extends DatabaseObject {
    /**
     * @see wcf\data\DatabaseObject::$databaseTableName
     */
    protected static $databaseTableName = 'guildtool_feed_ACM';
    /**
     * @see wcf\data\DatabaseObject::$databaseTableIndexName
     */
    protected static $databaseTableIndexName = 'feedID';

    public $wowChar = null;

    public $wowACM = null;

    public function __construct($id, array $row = null, DatabaseObject $object = null) {
        parent::__construct($id, $row, $object);
        if (intval($this->feedID) > 0) {
            if (intval($this->charID) != 0) $this->wowChar = new WoWCharacter($this->charID);
            if (intval($this->acmID) != 0) $this->wowACM  = new WoWACM($this->acmID);
        }
    }

    public static function create($acmfeeddata) {
        if (empty($acmfeeddata['achievement']['id'])) {
            throw new SystemException('Data Error');
        }
        $realm = BNETAPI::getHomeRealm($acmfeeddata['character'], true);
        if ($realm['status']) {
            $wowc = WoWCharacter::GetByName($acmfeeddata['character'], $realm['data']);
            if (intval($wowc->getObjectID())==0) {
                $bnetval = BNETAPI::getCharacterDetails($acmfeeddata['character'], $realm['data'], array('guild'));
                if ($bnetval['status']) $wowc = WoWCharacterEditor::createFromBNET($bnetval['data']);
            }
            $sql = 'SELECT *
                    FROM wcf'.WCF_N.'_guildtool_feed_ACM
                    WHERE  acmID = ? AND charID = ?
                    LIMIT 1';
		    $statement = WCF::getDB()->prepareStatement($sql);
		    $statement->execute(array($acmfeeddata['achievement']['id'],$wowc->charID));
		    $row = $statement->fetchArray();
		    if (!$row)  {
                $acm = WoWACM::create($acmfeeddata['achievement']);
                $acmfeed = array(
                    'acmID' => $acm->acmID,
                    'time' => $acmfeeddata['timestamp'] / 1000,
                    'charID' => $wowc->charID,
                 );
                return WoWFeedACMEditor::create($acmfeed);
            } 
            else{
                return new WoWFeedACM($row['feedID']);
            }
        } 
        else {
            throw new SystemException('b.net Error');
        }
    }
}
