<?php
namespace wcf\data\wow\character;
use wcf\data\DatabaseObjectEditor;
use wcf\data\AbstractDatabaseObjectAction;
use wcf\data\wow\group\WoWGroup;
use wcf\data\user\User;
use wcf\data\user\UserEditor;
use\wcf\system\WCF;
use wcf\system\exception\UserInputException;



/**
 * Provides functions to edit a WoW Character.
 * 
 * @author	Veneanar Falkenbann
 * @copyright	2015 Sylvanas Garde
 * @package	com.sylvanasgarde.tools
 * @subpackage	system.BNET
 * @category	Guild Tools
 */
class WoWCharacterAction extends AbstractDatabaseObjectAction {
	/**
     * @see	\wcf\data\AbstractDatabaseObjectAction::$className
     */
	public $className = 'wcf\data\wow\character\WoWCharacterEditor';
	
	/**
     * @see	\wcf\data\AbstractDatabaseObjectAction::$permissionsUpdate
     */
	protected $permissionsUpdate = array('admin.guildtool.canEditChar');
	
	/**
     * @see	\wcf\data\AbstractDatabaseObjectAction::$requireACP
     */
	protected $requireACP = array('create', 'delete');

	/**
     * Validates permissions and parameters.
     */
	public function validateAssignUser() {
        if (!isset($this->parameters['username']) || empty($this->parameters['username'])) throw new UserInputException('username'); 
        parent::validateUpdate();
	}
/**
     * assign the Character to an User
     *  
     */
    public function assignUser() {
        $user = User::getUserByUsername($this->parameters['username']);
        $characterAction = new WoWCharacterAction($this->objectIDs, 'update', array(
            'data' => array(
                'userID' => $user->userID
            )
        ));
        $characterAction->executeAction();
    }

    /**
     * Validates permissions and parameters.
     */
	public function validateAssignGroup() {
        $this->validateRemoveFromGroup();
    }

    /**
     * Validates permissions and parameters.
     */
    public function validateRemoveFromGroup() {
        if (empty($this->objects)) {
			$this->readObjects();
			if (empty($this->objects)) {
				throw new UserInputException('groupid');
			}
		}
        if (!isset($this->parameters['groupid'])) throw new UserInputException('groupid'); 
        $groupID = intval($this->parameters['groupid']);

        $sql = "SELECT	DISTINCT GroupID
			FROM	wcf".WCF_N."_guildtool_guildgroups
			";
		$statement = WCF::getDB()->prepareStatement($sql);
		$statement->execute();
        $groupIDs = array();
		while ($row = $statement->fetchArray()) {
			$groupIDs[] =intval( $row['GroupID']);
		}
        if (!in_array($groupID, $groupIDs)) throw new UserInputException('groupid');
		parent::validateUpdate();
	}

    /**
     * assign the Character to a Group
     *  
     */
    public function assignGroup() {
        if (empty($this->objects)) {
			$this->readObjects();
		}
        $WoWChar = new WoWCharacter($this->objectIDs[0]);
		$group = new WoWGroup(intval($this->parameters['groupid']));

        if ($WoWChar->userID != 0 && $group->wcfGroupID !=0) {
            $user = new User($WoWChar->userID);
            $userEdit = new UserEditor($user);
            $userEdit->addToGroup($group->wcfGroupID);
        } 
        $olddata = unserialize($WoWChar->guildGroup);
        $olddata[] = intval($group->getObjectID());
        $characterAction = new WoWCharacterAction($this->objectIDs, 'update', array(
            'data' => array(
                'guildGroup' => serialize($olddata)
            )
        ));
        $characterAction->executeAction();
    }

    public function removeFromGroup() {
        if (empty($this->objects)) {
			$this->readObjects();
		}
        $WoWChar = new WoWCharacter($this->objectIDs[0]);
		$group = new WoWGroup(intval($this->parameters['groupid']));

        if ($WoWChar->userID != 0 && $group->wcfGroupID != 0) {
            $user = new User($WoWChar->userID);
            $userEdit = new UserEditor($user);
            $userEdit->removeFromGroup($group->wcfGroupID);
        } 
        $olddata = unserialize($WoWChar->guildGroup);
        if(($key = array_search(intval($this->parameters['groupid']), $olddata)) !== false) {
                unset($olddata[$key]);
            }
        $characterAction = new WoWCharacterAction($this->objectIDs, 'update', array(
            'data' => array(
                'guildGroup' => serialize($olddata)
            )
        ));
        $characterAction->executeAction();
        
    }

    /**
     * Validates permissions and parameters.
     */
	public function validateSetMain() {
        if (empty($this->objects)) {
			$this->readObjects();
		    if (empty($this->objects)) {
				throw new UserInputException('groupid');
			}
		}
    parent::validateUpdate();
    }
    /**
     * mark the Character as main
     *  
     */
    public function setMain() {
        $WoWChar = new WoWCharacter($this->objectIDs[0]);
        $WoWCharEditor = new WoWCharacterEditor($WoWChar);
        $WoWCharEditor->setMain();
    }


}
