{include file='documentHeader'}
<head>
	<title>{lang}wcf.page.GuildTool.GroupRoaster.title{/lang} - {PAGE_TITLE|language}</title>
	{include file='headInclude' sandbox=false}
</head>

<body id="tpl{$templateName|ucfirst}">
	{include file='header'}

	<header class="boxHeadline">    
		<h1>{lang}wcf.page.GuildTool.GroupRoaster.title{/lang}</h1>  
	</header>

	{include file='userNotice'}

<div class="contentNavigation">
	{pages print=true assign=pagesLinks pages=$pageCount controller="GroupRoaster" id=1 link="pageNo=%d&sortField=$sortField&sortOrder=$sortOrder"}
	<nav>
		<ul>
			{if $__wcf->session->getPermission('admin.user.canAddUser')}
				<li><a href="{link controller='UserAdd'}{/link}" class="button"><span class="icon icon16 icon-plus"></span> <span>{lang}wcf.acp.user.add{/lang}</span></a></li>
			{/if}
			{event name='contentNavigationButtonsTop'}
		</ul>
	</nav>
</div>
    <script data-relocate="true">
		//<![CDATA[

		
		
		$(function() {
			var clicked_element = 0;
			var isRequestAvaible = false;
			
			$('.userField').each(function(i, obj) {
				new WCF.Search.User(obj, null, false, [ ], true);
			});
			$('.userField').change(function(e) {
                $(this).closest('tr').find('td:last').find('.jsSendButton').addClass('blue');
				$(clicked_element).removeClass('icon-ok').addClass('icon-save');
				isRequestAvaible = true;
            });
			$('.GroupDropDown').change(function(e) {
                $(this).closest('tr').find('td:last').find('.jsSendButton').addClass('blue');
				$(clicked_element).removeClass('icon-ok').addClass('icon-save');
				isRequestAvaible = true;
            });
			
			$('.jsSetMainButton').click(function() {
				var selectedCharid = $(this).closest('tr').data('id');
				clicked_element = this;
				$(clicked_element).removeClass('yellow');
				$(this).removeClass('icon-certificate').addClass('icon-spinner');

                var $proxy = new WCF.Action.Proxy({
					success: function(textStatus, jqXHR) { 
						 $(clicked_element).removeClass('icon-spinner').addClass('icon-ok');
						 $(clicked_element).addClass('green');
						 isRequestAvaible = true;
					},
					failure: function(textStatus, jqXHR) { 
						 $(clicked_element).removeClass('icon-spinner').addClass('icon-exclamation-sign');
						 $(clicked_element).addClass('red');
						 isRequestAvaible = true;
					}
				});
				$proxy.setOption('data', {
					actionName: 'setMain',
					className: 'wcf\\data\\wow\\character\\WoWCharacterAction',
					objectIDs : [ selectedCharid ]
				});
				isRequestAvaible = false;
				$proxy.sendRequest();	
            });
			
			$('.jsSendButton').click(function() {
				if (!isRequestAvaible) return;
				
				var selectedUsername = $(this).closest('tr').find('td:nth-last-child(2)').find('input:text').val();
				var selectedCharid = $(this).closest('tr').data('id');
				var selectdGroup = parseInt($(this).closest('tr').find('td:nth-last-child(3)').find('.GroupDropDown').val());
				clicked_element = this;
				$(clicked_element).removeClass('blue');
				$(this).removeClass('icon-save').addClass('icon-spinner');
				
				var $proxy = new WCF.Action.Proxy({
					success: function(textStatus, jqXHR) { 
						 $(clicked_element).removeClass('icon-spinner').addClass('icon-ok');
						 $(clicked_element).addClass('green');
						 isRequestAvaible = true;
					},
					failure: function(textStatus, jqXHR) { 
						 $(clicked_element).removeClass('icon-spinner').addClass('icon-exclamation-sign');
						 $(clicked_element).addClass('red');
						 isRequestAvaible = true;
					}
				});
				
				if (selectdGroup > 0) {
					$proxy.setOption('data', {
						actionName: 'assignGroup',
						className: 'wcf\\data\\wow\\character\\WoWCharacterAction',
						objectIDs : [ selectedCharid ],
						parameters: {
							groupid: selectdGroup
						}
					});
					$(this).removeClass('icon-save').addClass('icon-spinner');
					isRequestAvaible = false;
					$proxy.sendRequest();	
				}
				if (selectedUsername.length > 2) {
					$proxy.setOption('data', {
						actionName: 'assignUser',
						className: 'wcf\\data\\wow\\character\\WoWCharacterAction',
						objectIDs : [ selectedCharid ],
						parameters: {
							username: selectedUsername
						}
					});
					isRequestAvaible = false;
					$proxy.sendRequest();	
				}
			});
			$('.jsSetMainButton').click(function() {
				var selectedCharid = $(this).closest('tr').data('id');
				clicked_element = this;
				$(clicked_element).removeClass('yellow');
				$(this).removeClass('icon-eject').addClass('icon-spinner');
                var $proxy = new WCF.Action.Proxy({
					success: function(textStatus, jqXHR) { 
						 $(clicked_element).removeClass('icon-spinner').addClass('icon-ok');
						 $(clicked_element).addClass('green');
						 isRequestAvaible = true;
					},
					failure: function(textStatus, jqXHR) { 
						 $(clicked_element).removeClass('icon-spinner').addClass('icon-exclamation-sign');
						 $(clicked_element).addClass('red');
						 isRequestAvaible = true;
					}
				});
				$proxy.setOption('data', {
					actionName: 'setMain',
					className: 'wcf\\data\\wow\\character\\WoWCharacterAction',
					objectIDs : [ selectedCharid ],
					parameters: {
						objectIDs : [ selectedCharid ]
					}
				});
				isRequestAvaible = false;
				$proxy.sendRequest();	
            });
			
			// 
		});
		//]]> 
	</script>
{if $WoWChars|count}
	<div id="userTableContainer" class="tabularBox tabularBoxTitle marginTop">
		<header>
			<h2>Übersicht der Gildenmitglieder</h2>
		</header>
		
		<table data-type="com.woltlab.wcf.user" class="table jsClipboardContainer">
			<thead>
				<tr>
					<th class="columnID columnUserID{if $sortField == 'charID'} active {@$sortOrder}{/if}" colspan="2"><a href="{link controller='GroupRoaster'}pageNo={@$pageNo}&sortField=charID&sortOrder={if $sortField == 'charID' && $sortOrder == 'ASC'}DESC{else}ASC{/if}{/link}">{lang}wcf.global.objectID{/lang}</a></th>
					<th class="columnTitle columnDetails" colspan="2">Details</a></th>
					<th class="columnTitle columnCharname{if $sortField == 'charname'} active {@$sortOrder}{/if}" colspan="2"><a href="{link controller='GroupRoaster'}pageNo={@$pageNo}&sortField=charname&sortOrder={if $sortField == 'charname' && $sortOrder == 'ASC'}DESC{else}ASC{/if}{/link}">Charname</a></th>
					<th class="columnTitle columnGroups" colspan="2">Gruppen</a></th>
					<th class="columnTitle columnUsername{if $sortField == 'userID'} active {@$sortOrder}{/if}" colspan="2"><a href="{link controller='GroupRoaster'}pageNo={@$pageNo}&sortField=userID&sortOrder={if $sortField == 'userID' && $sortOrder == 'ASC'}DESC{else}ASC{/if}{/link}">{lang}wcf.user.username{/lang}</a></th>
                    {if $__wcf->session->getPermission('admin.user.canManageUserOption')}
						<th class="columnTitle columnTools" colspan="2">Admin</a></th>
					{/if}
					
				</tr>
			</thead>
			
			<tbody>
				{foreach from=$WoWChars item=char}
					<tr class="jsUserRow jsClipboardObject" data-id="{$char->charID}">
						<td class="columnID columnUserID">{@$char->charID}</td>
						<td class="columnIcon"><p class="framed"></p></td>
						<td class="columnTitle columnDetails" colspan="2"><img src="{$char->avatar}" alt="Wow Portrait" height="32" width="32"></td>
						<td class="columnTitle columnUsername">
                        {if $char->isMain == 1}
                        <span class="icon icon16 icon-certificate jsTooltip yellow" title="Hauptcharekter"></span>
                        {/if}
                        <span class="jsTooltip wowClass{$char->class}" title="{lang}wcf.page.GuildTool.GroupRoaster.race{$char->race}{/lang} {lang}wcf.page.GuildTool.GroupRoaster.class{$char->class}{/lang} auf {$char->realmname}">
                        {$char->charname} ({@$char->level})
                        </span>
                        </td>
						<td class="columnTitle columnGroups" colspan="2">
                        {foreach from=$char->groupList item=$chargroup}
                        	{$chargroup->name},		 
                        {/foreach}
                        {if $__wcf->session->getPermission('admin.user.canManageUserOption')}
                            neu: <select name="group" class="GroupDropDown">
                            {foreach from=$WoWGroups item=$WoWGroup}
                                <option selected value="0">keine</option>
                                <option value="{$WoWGroup->groupID}">{$WoWGroup->name}</option>
                            {/foreach}
                            </select>
                        {/if}
                        </td>
						<td class="columnTitle columnUsername" colspan="2">
                         {if $__wcf->session->getPermission('admin.user.canManageUserOption')}
                        <span><input name="forumacc" class="small userField" type="text" value="{if $char->userID != 0}{$char->user->username}{/if}"></span>
						{else}
                        	{if $char->userID != 0}
								{$char->user->username};
                        	{/if}
                       {/if}
                        </td>
                       {if $__wcf->session->getPermission('admin.user.canManageUserOption')}
                        <td class="columnTitle columnTools" colspan="2">
                        <span class="icon icon16 icon-save jsSendButton jsTooltip pointer" title="Änderungen speichern"></span>
						<span class="icon icon16 icon-certificate jsSetMainButton jsTooltip pointer" title="Als Hauptchar markieren"></span>
						<span class="icon icon16 icon-eject jsRemoveGroupButton jsTooltip pointer" title="aus ausgewählter Gruppe entfernen"></span>
						<span class="icon icon16 icon-remove jsRemoveButton jsTooltip pointer" title="Charakter löschen"></span>
                        
                        
                        </td>
                        {/if}
					</tr>
				{/foreach}
			</tbody>
		</table>
	</div>
{/if}
{include file='footer'}
</body>
</html>